/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.workspace.ui.services.internal;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.StatusException;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.util.internal.FileUtil;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.diagram.def.IDiagramEditorPageDef;
import org.eclipse.sapphire.ui.diagram.def.LayoutPersistence;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.layout.standard.StandardDiagramLayout;
import org.eclipse.sapphire.ui.diagram.layout.standard.StandardDiagramLayoutPersistenceService;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class ProjectDiagramLayoutPersistenceService
extends StandardDiagramLayoutPersistenceService {
    protected String computeLayoutFileName(IEditorInput editorInput) throws CoreException, IOException {
        if (editorInput instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)editorInput;
            IFile ifile = fileEditorInput.getFile();
            String uniquePath = ifile.getProjectRelativePath().toPortableString();
            return MiscUtil.createStringDigest((String)uniquePath);
        }
        return super.computeLayoutFileName(editorInput);
    }

    protected StandardDiagramLayout initLayoutModel() {
        StandardDiagramLayout layoutModel = null;
        try {
            IFile layoutFile;
            String fileName = this.computeLayoutFileName(this.editorInput);
            if (fileName != null && (layoutFile = this.getLayoutPersistenceFile(fileName)) != null) {
                XmlResourceStore resourceStore = new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(layoutFile));
                layoutModel = (StandardDiagramLayout)StandardDiagramLayout.TYPE.instantiate((Resource)new RootXmlResource(resourceStore));
            }
        }
        catch (Exception e) {
            SapphireUiFrameworkPlugin.log((Throwable)e);
        }
        return layoutModel;
    }

    protected IFile getLayoutPersistenceFile(String fileName) throws StatusException, CoreException {
        IFileEditorInput fileInput;
        IProject proj;
        if (this.editorInput instanceof IFileEditorInput && (proj = (fileInput = (IFileEditorInput)this.editorInput).getFile().getProject()) != null) {
            IFolder layoutIFolder = proj.getFolder(".settings/org.eclipse.sapphire.ui.diagram/layouts");
            File layoutFolder = layoutIFolder.getLocation().toFile();
            if (!layoutFolder.exists()) {
                FileUtil.mkdirs((File)layoutFolder);
                layoutIFolder.refreshLocal(1, null);
            }
            IFile layoutFile = layoutIFolder.getFile(fileName);
            layoutFile.refreshLocal(1, null);
            return layoutFile;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            SapphireDiagramEditorPagePart diagramPagePart;
            IDiagramEditorPageDef pageDef;
            ISapphirePart part = (ISapphirePart)context.find(ISapphirePart.class);
            return part instanceof SapphireDiagramEditorPagePart && (pageDef = (diagramPagePart = (SapphireDiagramEditorPagePart)part).getPageDef()).getLayoutPersistence().getContent() == LayoutPersistence.PROJECT;
        }

        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new ProjectDiagramLayoutPersistenceService();
        }
    }
}

