/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;

public final class ListenerContext {
    private static final boolean TRACE = false;
    private final Set<Listener> listeners = new LinkedHashSet<Listener>();
    private Queue<BroadcastJob> queue = new ConcurrentLinkedQueue<BroadcastJob>();
    private final Map<Class<? extends Event>, Event> suspended = new HashMap<Class<? extends Event>, Event>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void coordinate(ListenerContext context) {
        ListenerContext listenerContext = this;
        synchronized (listenerContext) {
            this.queue = context == null ? new ConcurrentLinkedQueue() : context.queue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attach(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        ListenerContext listenerContext = this;
        synchronized (listenerContext) {
            return this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean detach(Listener listener) {
        boolean removed;
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        ListenerContext listenerContext = this;
        synchronized (listenerContext) {
            removed = this.listeners.remove(listener);
        }
        if (removed) {
            for (BroadcastJob job : this.queue) {
                if (!job.listener().equals(listener)) continue;
                this.queue.remove(job);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(Event event) {
        boolean post;
        Class<?> eventType = event.getClass();
        ListenerContext listenerContext = this;
        synchronized (listenerContext) {
            if (this.suspended.containsKey(eventType)) {
                this.suspended.put(eventType, event);
                post = false;
            } else {
                post = true;
            }
        }
        if (post) {
            for (BroadcastJob job : this.queue) {
                if (!event.supersedes(job.event())) continue;
                this.queue.remove(job);
            }
            listenerContext = this;
            synchronized (listenerContext) {
                for (Listener listener : this.listeners) {
                    this.queue.add(new BroadcastJob(listener, event));
                }
            }
        }
    }

    public void broadcast() {
        BroadcastJob job = this.queue.poll();
        while (job != null) {
            job.run();
            job = this.queue.poll();
        }
    }

    public void broadcast(Event event) {
        this.post(event);
        this.broadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(Class<? extends Event> eventType) {
        ListenerContext listenerContext = this;
        synchronized (listenerContext) {
            if (!this.suspended.containsKey(eventType)) {
                this.suspended.put(eventType, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(Class<? extends Event> eventType) {
        Event event = null;
        ListenerContext listenerContext = this;
        synchronized (listenerContext) {
            event = this.suspended.remove(eventType);
        }
        if (event != null) {
            this.broadcast(event);
        }
    }

    private static final class BroadcastJob {
        private final Listener listener;
        private final Event event;

        public BroadcastJob(Listener listener, Event event) {
            this.listener = listener;
            this.event = event;
        }

        public Listener listener() {
            return this.listener;
        }

        public Event event() {
            return this.event;
        }

        public void run() {
            try {
                this.listener.handle(this.event);
            }
            catch (Exception e) {
                Sapphire.service(LoggingService.class).log(e);
            }
        }
    }
}

