/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.ListPropertyBinding;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.MasterConversionService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.modeling.CorruptedResourceExceptionInterceptor;
import org.eclipse.sapphire.modeling.ElementPropertyBinding;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.SourceLanguageLocalizationService;

public abstract class Resource {
    private final Resource parent;
    private Element element;
    private final Map<Property, PropertyBinding> bindings = new HashMap<Property, PropertyBinding>();
    private CorruptedResourceExceptionInterceptor corruptedResourceExceptionInterceptor;
    private final Map<Locale, LocalizationService> localizationServices = new HashMap<Locale, LocalizationService>();

    public Resource(Resource parent) {
        this.parent = parent;
    }

    public void init(Element element) {
        if (this.element != null) {
            throw new IllegalStateException();
        }
        this.element = element;
    }

    public Resource parent() {
        return this.parent;
    }

    public Resource root() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.root();
    }

    public final Element element() {
        return this.element;
    }

    public final PropertyBinding binding(PropertyDef property) {
        return this.binding(this.element.property(property));
    }

    public final ValuePropertyBinding binding(ValueProperty property) {
        return (ValuePropertyBinding)this.binding((PropertyDef)property);
    }

    public final ElementPropertyBinding binding(ElementProperty property) {
        return (ElementPropertyBinding)this.binding((PropertyDef)property);
    }

    public final ListPropertyBinding binding(ListProperty property) {
        return (ListPropertyBinding)this.binding((PropertyDef)property);
    }

    public final PropertyBinding binding(Property property) {
        PropertyBinding binding = this.bindings.get(property);
        if (binding == null) {
            binding = this.createBinding(property);
            if (binding == null) {
                throw new IllegalArgumentException();
            }
            binding.init(property);
            this.bindings.put(property, binding);
        }
        return binding;
    }

    protected abstract PropertyBinding createBinding(Property var1);

    public void save() throws ResourceStoreException {
        Resource root = this.root();
        if (this != root) {
            root.save();
        }
    }

    public <A> A adapt(Class<A> adapterType) {
        A result = Sapphire.service(MasterConversionService.class).convert(this, adapterType);
        if (result == null) {
            if (adapterType.isInstance(this)) {
                result = adapterType.cast(this);
            } else if (adapterType == LocalizationService.class) {
                result = adapterType.cast(this.getLocalizationService());
            } else if (this.parent != null) {
                result = this.parent.adapt(adapterType);
            }
        }
        return result;
    }

    public boolean isOutOfDate() {
        Resource root = this.root();
        if (this != root) {
            return root.isOutOfDate();
        }
        return false;
    }

    public final LocalizationService getLocalizationService() {
        return this.getLocalizationService(Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LocalizationService getLocalizationService(Locale locale) {
        Map<Locale, LocalizationService> map = this.localizationServices;
        synchronized (map) {
            LocalizationService service = this.localizationServices.get(locale);
            if (service == null && (service = this.initLocalizationService(locale)) != null) {
                this.localizationServices.put(locale, service);
            }
            return service;
        }
    }

    protected LocalizationService initLocalizationService(Locale locale) {
        Resource root = this.root();
        if (this != root) {
            return root.getLocalizationService(locale);
        }
        return SourceLanguageLocalizationService.INSTANCE;
    }

    public final void setCorruptedResourceExceptionInterceptor(CorruptedResourceExceptionInterceptor interceptor) {
        this.corruptedResourceExceptionInterceptor = interceptor;
    }

    protected final boolean validateCorruptedResourceRecovery() {
        if (this.corruptedResourceExceptionInterceptor != null) {
            return this.corruptedResourceExceptionInterceptor.shouldAttemptRepair();
        }
        return false;
    }

    public void dispose() {
        for (PropertyBinding binding : this.bindings.values()) {
            try {
                binding.dispose();
            }
            catch (Exception e) {
                Sapphire.service(LoggingService.class).log(e);
            }
        }
    }
}

