/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class BinaryData {
    private final byte[] data;

    public BinaryData(InputStream stream) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        int count = stream.read(bytes);
        while (count != -1) {
            buf.write(bytes, 0, count);
            count = stream.read(bytes);
        }
        this.data = buf.toByteArray();
    }

    public BinaryData(byte[] data) {
        this.data = new byte[data.length];
        System.arraycopy(data, 0, this.data, 0, data.length);
    }

    public InputStream contents() {
        return new ByteArrayInputStream(this.data);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BinaryData) {
            return Arrays.equals(this.data, ((BinaryData)obj).data);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }
}

