/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;

public final class EqualityFunction
extends Function {
    public static EqualityFunction create(Function a, Function b) {
        EqualityFunction function = new EqualityFunction();
        function.init(a, b);
        return function;
    }

    @Override
    public String name() {
        return "==";
    }

    @Override
    public boolean operator() {
        return true;
    }

    @Override
    public int precedence() {
        return 5;
    }

    @Override
    public FunctionResult evaluate(FunctionContext context) {
        return new FunctionResult(this, context){

            @Override
            protected Object evaluate() {
                Object a = this.operand(0);
                if (a instanceof Value) {
                    a = ((Value)a).content();
                } else if (a instanceof ElementHandle) {
                    a = ((ElementHandle)a).content();
                }
                Object b = this.operand(1);
                if (b instanceof Value) {
                    b = ((Value)b).content();
                } else if (b instanceof ElementHandle) {
                    b = ((ElementHandle)b).content();
                }
                return this.equal(a, b);
            }
        };
    }
}

