/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.util.List;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.el.ConcatFunction;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.util.ListFactory;

public abstract class Function {
    @Text(value="Function {0} missing operand {1}.")
    private static LocalizableText missingOperandMessage;
    private Object origin;
    private boolean originInitialized;
    private List<Class<?>> signature;
    private List<Function> operands = ListFactory.empty();

    static {
        LocalizableText.init(Function.class);
    }

    public final void initSignature(List<Class<?>> signature) {
        this.signature = signature;
    }

    public final void init(Function ... operands) {
        this.operands = ListFactory.unmodifiable(operands);
    }

    public final void init(List<Function> operands) {
        this.operands = ListFactory.unmodifiable(operands);
    }

    public final void initOrigin(Object origin, boolean applyToOperands) {
        if (this.originInitialized) {
            throw new IllegalStateException();
        }
        this.origin = origin;
        if (applyToOperands) {
            for (Function operand : this.operands) {
                operand.initOrigin(origin, true);
            }
        }
    }

    public final Object origin() {
        return this.origin;
    }

    public abstract String name();

    public boolean operator() {
        return false;
    }

    public int precedence() {
        return 1;
    }

    public final List<Class<?>> signature() {
        return this.signature;
    }

    public final List<Function> operands() {
        return this.operands;
    }

    public final Function operand(int position) {
        if (position < this.operands.size()) {
            return this.operands.get(position);
        }
        throw new FunctionException(missingOperandMessage.format(this.getClass().getName(), String.valueOf(position)));
    }

    public abstract FunctionResult evaluate(FunctionContext var1);

    public final String toString() {
        StringBuilder buf = new StringBuilder();
        if (this instanceof Literal || this instanceof ConcatFunction) {
            this.toString(buf, true);
        } else {
            buf.append("${ ");
            this.toString(buf, false);
            buf.append(" }");
        }
        return buf.toString();
    }

    public void toString(StringBuilder buf, boolean topLevel) {
        String name = this.name();
        if (this.operator()) {
            int precedence = this.precedence();
            boolean first = true;
            boolean addOperatorBeforeNext = this.operands.size() == 1;
            for (Function operand : this.operands) {
                boolean parens;
                if (addOperatorBeforeNext) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append(' ');
                    }
                    buf.append(name);
                    buf.append(' ');
                } else {
                    addOperatorBeforeNext = true;
                    first = false;
                }
                boolean bl = parens = precedence < operand.precedence();
                if (parens) {
                    buf.append("( ");
                }
                operand.toString(buf, false);
                if (!parens) continue;
                buf.append(" )");
            }
        } else {
            buf.append(name);
            buf.append('(');
            if (!this.operands.isEmpty()) {
                boolean first = true;
                for (Function operand : this.operands) {
                    if (first) {
                        buf.append(',');
                    } else {
                        first = false;
                    }
                    buf.append(' ');
                    operand.toString(buf, false);
                }
                buf.append(' ');
            }
            buf.append(')');
        }
    }
}

