/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.MasterConversionService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionException;

public abstract class FunctionResult {
    @Text(value="Cannot convert {0} to {1}.")
    private static LocalizableText cannotCastMessage;
    @Text(value="Function {0} missing operand {1}.")
    private static LocalizableText missingOperandMessage;
    @Text(value="Function {0} does not accept nulls in position {1}.")
    private static LocalizableText operandNullMessage;
    @Text(value="Function {0} expects {2} in position {1}, but {3} was found. A conversion was not possible.")
    private static LocalizableText operandWrongTypeMessage;
    private final Function function;
    private final FunctionContext context;
    private final List<FunctionResult> operands;
    private Set<Property> properties;
    private final ListenerContext listeners;
    private final Listener listener;
    private Object value;
    private Status status;

    static {
        LocalizableText.init(FunctionResult.class);
    }

    public FunctionResult(Function function, FunctionContext context) {
        this.function = function;
        this.context = context;
        this.listeners = new ListenerContext();
        this.operands = Collections.unmodifiableList(this.initOperands());
        this.listener = this.operands.isEmpty() ? null : new Listener(){

            @Override
            public void handle(Event event) {
                FunctionResult.this.refresh();
            }
        };
        this.init();
        this.refresh(false);
    }

    protected List<FunctionResult> initOperands() {
        List<Function> operands = this.function().operands();
        if (operands.size() == 0) {
            return Collections.emptyList();
        }
        if (operands.size() == 1) {
            return Collections.singletonList(operands.get(0).evaluate(this.context));
        }
        ArrayList<FunctionResult> result = new ArrayList<FunctionResult>();
        for (Function operand : operands) {
            result.add(operand.evaluate(this.context));
        }
        return result;
    }

    protected void init() {
    }

    public final Function function() {
        return this.function;
    }

    public final FunctionContext context() {
        return this.context;
    }

    public final List<FunctionResult> operands() {
        for (FunctionResult operand : this.operands) {
            this.listenToOperand(operand);
        }
        return this.operands;
    }

    public final Object operand(int position) {
        if (position < this.operands.size()) {
            FunctionResult operand = this.operands.get(position);
            this.listenToOperand(operand);
            return operand.value();
        }
        throw new FunctionException(missingOperandMessage.format(this.getClass().getName(), String.valueOf(position)));
    }

    public final <T> T operand(int position, Class<T> type, boolean nullable) {
        T operandTyped;
        Object operand = this.operand(position);
        try {
            operandTyped = this.cast(operand, type);
        }
        catch (FunctionException functionException) {
            String msg = operandWrongTypeMessage.format(this.function().name(), position, type.getName(), operand.getClass().getName());
            throw new FunctionException(msg);
        }
        if (operandTyped == null && !nullable) {
            String msg = operandNullMessage.format(this.function().name(), position);
            throw new FunctionException(msg);
        }
        return operandTyped;
    }

    private void listenToOperand(FunctionResult operand) {
        operand.attach(this.listener);
        Object obj = null;
        try {
            obj = operand.value();
        }
        catch (FunctionException functionException) {}
        if (obj instanceof Property) {
            Property property = (Property)obj;
            property.attach(this.listener);
            if (this.properties == null) {
                this.properties = new HashSet<Property>(1);
            }
            this.properties.add(property);
        }
    }

    protected abstract Object evaluate() throws FunctionException;

    public final Object value() throws FunctionException {
        if (this.status.severity() == Status.Severity.ERROR) {
            throw new FunctionException(this.status);
        }
        return this.value;
    }

    public final Status status() {
        return this.status;
    }

    protected final void refresh() {
        this.refresh(true);
    }

    private final void refresh(boolean broadcastIfNecessary) {
        Object newValue = null;
        Status newStatus = Status.createOkStatus();
        if (this.properties != null) {
            for (Property property : this.properties) {
                property.detach(this.listener);
            }
            this.properties.clear();
        }
        try {
            newValue = this.evaluate();
        }
        catch (FunctionException e) {
            newStatus = e.status();
        }
        catch (Exception e) {
            newStatus = Status.createErrorStatus(e);
        }
        if (newValue instanceof Function) {
            throw new IllegalStateException();
        }
        if (!this.equal(this.value, newValue) || !this.equal(this.status, newStatus)) {
            this.value = newValue;
            this.status = newStatus;
            if (broadcastIfNecessary) {
                this.listeners.broadcast(new Event());
            }
        }
    }

    public final boolean attach(Listener listener) {
        return this.listeners.attach(listener);
    }

    public final boolean detach(Listener listener) {
        return this.listeners.detach(listener);
    }

    public void dispose() {
        for (FunctionResult operand : this.operands) {
            operand.dispose();
        }
        if (this.properties != null) {
            for (Property property : this.properties) {
                property.detach(this.listener);
            }
            this.properties.clear();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected final <X> X cast(Object obj, Class<X> type) {
        if (obj instanceof FunctionResult) {
            throw new IllegalArgumentException();
        }
        if (obj != null && type.isAssignableFrom(obj.getClass())) {
            return type.cast(obj);
        }
        try {
            if (type == String.class) {
                if (obj instanceof String) {
                    return type.cast(obj);
                }
                if (obj == null) {
                    return type.cast("");
                }
                if (obj instanceof Value) {
                    String res = ((Value)obj).text();
                    res = res == null ? "" : res;
                    return type.cast(res);
                }
                if (obj instanceof List || obj instanceof Set) {
                    StringBuilder res = new StringBuilder();
                    boolean first = true;
                    for (Object entry : (Collection)obj) {
                        if (first) {
                            first = false;
                        } else {
                            res.append(',');
                        }
                        String str = this.cast(entry, String.class);
                        if (str == null) continue;
                        res.append(str);
                    }
                    return type.cast(res.toString());
                }
                if (obj.getClass().isArray()) {
                    StringBuilder res = new StringBuilder();
                    int i = 0;
                    int n = Array.getLength(obj);
                    while (i < n) {
                        String str;
                        if (i > 0) {
                            res.append(',');
                        }
                        if ((str = this.cast(Array.get(obj, i), String.class)) != null) {
                            res.append(str);
                        }
                        ++i;
                    }
                    return type.cast(res.toString());
                }
            }
            if (Number.class.isAssignableFrom(type)) {
                if (obj instanceof Value) {
                    obj = ((Value)obj).content();
                }
                if (obj == null || obj instanceof String && ((String)obj).length() == 0) {
                    obj = (short)0;
                } else if (obj instanceof Character) {
                    obj = (short)((Character)obj).charValue();
                } else if (obj instanceof Boolean) {
                    throw new FunctionException(cannotCastMessage.format(obj.getClass().getName(), type.getName()));
                }
                if (obj.getClass() == type) {
                    return type.cast(obj);
                }
                if (obj instanceof Number) {
                    if (type == BigInteger.class) {
                        if (obj instanceof BigDecimal) {
                            return type.cast(((BigDecimal)obj).toBigInteger());
                        }
                        return type.cast(BigInteger.valueOf(((Number)obj).longValue()));
                    }
                    if (type == BigDecimal.class) {
                        if (obj instanceof BigInteger) {
                            return type.cast(new BigDecimal((BigInteger)obj));
                        }
                        return type.cast(new BigDecimal(((Number)obj).doubleValue()));
                    }
                    if (type == Byte.class) {
                        return type.cast(((Number)obj).byteValue());
                    }
                    if (type == Short.class) {
                        return type.cast(((Number)obj).shortValue());
                    }
                    if (type == Integer.class) {
                        return type.cast(((Number)obj).intValue());
                    }
                    if (type == Long.class) {
                        return type.cast(((Number)obj).longValue());
                    }
                    if (type == Float.class) {
                        return type.cast(Float.valueOf(((Number)obj).floatValue()));
                    }
                    if (type == Double.class) {
                        return type.cast(((Number)obj).doubleValue());
                    }
                } else if (obj instanceof String) {
                    if (type == BigDecimal.class) {
                        return type.cast(new BigDecimal((String)obj));
                    }
                    if (type == BigInteger.class) {
                        return type.cast(new BigInteger((String)obj));
                    }
                    if (type == Byte.class) {
                        return type.cast(Byte.valueOf((String)obj));
                    }
                    if (type == Short.class) {
                        return type.cast(Short.valueOf((String)obj));
                    }
                    if (type == Integer.class) {
                        return type.cast(Integer.valueOf((String)obj));
                    }
                    if (type == Long.class) {
                        return type.cast(Long.valueOf((String)obj));
                    }
                    if (type == Float.class) {
                        return type.cast(Float.valueOf((String)obj));
                    }
                    if (type == Double.class) {
                        return type.cast(Double.valueOf((String)obj));
                    }
                }
                throw new FunctionException(cannotCastMessage.format(obj.getClass().getName(), type.getName()));
            }
            if (type == Character.class) {
                if (obj instanceof Value) {
                    obj = ((Value)obj).content();
                }
                if (obj == null || obj instanceof String && ((String)obj).length() == 0) {
                    return type.cast(Character.valueOf('\u0000'));
                }
                if (obj instanceof Character) {
                    return type.cast(obj);
                }
                if (obj instanceof Boolean) {
                    throw new FunctionException(cannotCastMessage.format(obj.getClass().getName(), type.getName()));
                }
                if (obj instanceof Number) {
                    return type.cast(Character.valueOf((char)this.cast(obj, Short.class).shortValue()));
                }
                if (obj instanceof String) {
                    return type.cast(Character.valueOf(((String)obj).charAt(0)));
                }
                throw new FunctionException(cannotCastMessage.format(obj.getClass().getName(), type.getName()));
            }
            if (type == Boolean.class) {
                if (obj instanceof Value) {
                    obj = ((Value)obj).content();
                }
                if (obj == null || obj instanceof String && ((String)obj).length() == 0) {
                    return type.cast(Boolean.FALSE);
                }
                if (obj instanceof Boolean) {
                    return type.cast(obj);
                }
                if (obj instanceof String) {
                    return type.cast(Boolean.valueOf((String)obj));
                }
                throw new FunctionException(cannotCastMessage.format(obj.getClass().getName(), type.getName()));
            }
            if (List.class.isAssignableFrom(type)) {
                if (obj instanceof Value) {
                    obj = ((Value)obj).content();
                }
                if (obj == null) {
                    return null;
                }
                if (obj instanceof List) {
                    return type.cast(obj);
                }
                if (obj instanceof Collection) {
                    return type.cast(new ArrayList((Collection)obj));
                }
                if (obj.getClass().isArray()) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    int i = 0;
                    int n = Array.getLength(obj);
                    while (i < n) {
                        list.add(Array.get(obj, i));
                        ++i;
                    }
                    return type.cast(list);
                }
                if (obj instanceof String) {
                    String str = (String)obj;
                    if (str.length() == 0) {
                        return type.cast(Collections.emptyList());
                    }
                    return type.cast(Arrays.asList(((String)obj).split("\\,")));
                }
                return type.cast(Collections.singletonList(obj));
            }
            if (obj instanceof Value) {
                obj = ((Value)obj).content();
            }
            if (obj == null) {
                return null;
            }
            if (type.isInstance(obj)) {
                return type.cast(obj);
            }
            if (obj instanceof String && ((String)obj).length() == 0) {
                return null;
            }
            Object origin = this.function.origin();
            MasterConversionService masterConversionService = origin instanceof Element ? ((Element)origin).service(MasterConversionService.class) : Sapphire.service(MasterConversionService.class);
            X result = type.cast(masterConversionService.convert(obj, type));
            if (result != null) {
                return result;
            }
            throw new FunctionException(cannotCastMessage.format(obj.getClass().getName(), type.getName()));
        }
        catch (FunctionException e) {
            if (!(obj instanceof String)) {
                try {
                    return this.cast(this.cast(obj, String.class), type);
                }
                catch (FunctionException functionException) {}
            }
            throw e;
        }
    }

    protected final boolean equal(Object a, Object b) {
        Object x;
        Value value;
        if (a instanceof Value && !(value = (Value)a).disposed()) {
            a = value.text();
        }
        if (b instanceof Value && !(value = (Value)b).disposed()) {
            b = value.text();
        }
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a instanceof BigDecimal || b instanceof BigDecimal) {
            x = this.cast(a, BigDecimal.class);
            BigDecimal y = this.cast(b, BigDecimal.class);
            return ((BigDecimal)x).equals(y);
        }
        if (a instanceof Float || a instanceof Double || b instanceof Float || b instanceof Double) {
            x = this.cast(a, Double.class);
            Double y = this.cast(b, Double.class);
            return ((Double)x).equals(y);
        }
        if (a instanceof BigInteger || b instanceof BigInteger) {
            x = this.cast(a, BigInteger.class);
            BigInteger y = this.cast(b, BigInteger.class);
            return ((BigInteger)x).equals(y);
        }
        if (a instanceof Byte || a instanceof Short || a instanceof Character || a instanceof Integer || a instanceof Long || b instanceof Byte || b instanceof Short || b instanceof Character || b instanceof Integer || b instanceof Long) {
            x = this.cast(a, Long.class);
            Long y = this.cast(b, Long.class);
            return ((Long)x).equals(y);
        }
        if (a instanceof Boolean || b instanceof Boolean) {
            x = this.cast(a, Boolean.class);
            Boolean y = this.cast(b, Boolean.class);
            return ((Boolean)x).equals(y);
        }
        if (a instanceof Enum) {
            return a == this.cast(b, a.getClass());
        }
        if (b instanceof Enum) {
            return this.cast(a, b.getClass()) == b;
        }
        if (a instanceof String || b instanceof String) {
            String y;
            x = this.cast(a, String.class);
            return ((String)x).compareTo(y = this.cast(b, String.class)) == 0;
        }
        return a.equals(b);
    }
}

