/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.io.File;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.AbsolutePath;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.services.PathValidationService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class AbsolutePathValidationService
extends PathValidationService {
    @Override
    protected Status compute() {
        Value value = this.context(Value.class);
        Path path = (Path)value.content(false);
        if (path != null) {
            File f = path.toFile();
            if (f.exists()) {
                if (this.validResourceType == FileSystemResourceType.FILE) {
                    if (f.isFile()) {
                        return this.validateExtensions(path);
                    }
                    String message = pathIsNotFile.format(path.toString());
                    return Status.createErrorStatus(message);
                }
                if (this.validResourceType == FileSystemResourceType.FOLDER && !f.isDirectory()) {
                    String message = pathIsNotFolder.format(path.toString());
                    return Status.createErrorStatus(message);
                }
            } else if (this.resourceMustExist) {
                if (this.validResourceType == FileSystemResourceType.FILE) {
                    String message = fileMustExist.format(path.toString());
                    return Status.createErrorStatus(message);
                }
                if (this.validResourceType == FileSystemResourceType.FOLDER) {
                    String message = folderMustExist.format(path.toString());
                    return Status.createErrorStatus(message);
                }
                String message = resourceMustExistMessage.format(path.toString());
                return Status.createErrorStatus(message);
            }
        }
        return Status.createOkStatus();
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && property.hasAnnotation(AbsolutePath.class) && Path.class.isAssignableFrom(property.getTypeClass());
        }
    }
}

