/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.address;

import java.util.Set;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.samples.address.Address;
import org.eclipse.sapphire.samples.zipcodes.ZipCodeRepository;
import org.eclipse.sapphire.services.PossibleValuesService;

public final class StatePossibleValuesService
extends PossibleValuesService {
    @Text(value="\"{0}\" is not a valid state postal code for the specified city and ZIP code.")
    private static LocalizableText invalidValueMessage;

    static {
        LocalizableText.init(StatePossibleValuesService.class);
    }

    protected void init() {
        final Address address = (Address)this.context(Address.class);
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                String state;
                StatePossibleValuesService.this.broadcast();
                Set values = StatePossibleValuesService.this.values();
                if (values.size() == 1 && !(state = (String)values.iterator().next()).equalsIgnoreCase(address.getState().text())) {
                    address.setState(state);
                }
            }
        };
        address.getCity().attach((Listener)listener);
        address.getZipCode().attach((Listener)listener);
    }

    protected void fillPossibleValues(Set<String> values) {
        Address address = (Address)this.context(Address.class);
        String city = address.getCity().text();
        String zip = address.getZipCode().text();
        values.addAll(ZipCodeRepository.getStateCodes(zip, city));
    }

    public String getInvalidValueMessage(String invalidValue) {
        return invalidValueMessage.format(new Object[]{invalidValue});
    }

    public boolean isCaseSensitive() {
        return false;
    }
}

