/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.architecture.internal;

import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.samples.architecture.ArchitectureSketch;
import org.eclipse.sapphire.samples.architecture.Component;
import org.eclipse.sapphire.services.ReferenceService;

public final class ComponentReferenceService
extends ReferenceService {
    private Listener listener;

    protected void init() {
        super.init();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                ComponentReferenceService.this.broadcast();
            }
        };
        ((ArchitectureSketch)this.context(ArchitectureSketch.class)).attach(this.listener, "Components/Name");
    }

    public Object resolve(String reference) {
        if (reference != null) {
            ArchitectureSketch arch = (ArchitectureSketch)this.context(ArchitectureSketch.class);
            for (Component component : arch.getComponents()) {
                if (!reference.equals(component.getName().text())) continue;
                return component;
            }
        }
        return null;
    }

    public void dispose() {
        ((ArchitectureSketch)this.context(ArchitectureSketch.class)).detach(this.listener, "Components/Name");
        super.dispose();
    }
}

