/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.calendar.integrated.internal;

import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.samples.calendar.integrated.IAttendee;
import org.eclipse.sapphire.samples.contacts.Contact;
import org.eclipse.sapphire.samples.contacts.ContactRepository;

public final class AttendeeResource
extends Resource {
    private final org.eclipse.sapphire.samples.calendar.IAttendee base;
    private final ContactRepository contacts;
    private final Listener listener;

    public AttendeeResource(Resource parent, org.eclipse.sapphire.samples.calendar.IAttendee base) {
        super(parent);
        this.base = base;
        this.contacts = this.adapt(ContactRepository.class);
        this.listener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                PropertyDef property = event.property().definition();
                IAttendee attendee = (IAttendee)AttendeeResource.this.element();
                if (property == org.eclipse.sapphire.samples.calendar.IAttendee.PROP_NAME) {
                    attendee.getName().refresh();
                    attendee.isInContactRepository().refresh();
                    attendee.getEMail().refresh();
                } else if (property == org.eclipse.sapphire.samples.calendar.IAttendee.PROP_TYPE) {
                    attendee.getType().refresh();
                } else if (property == ContactRepository.PROP_CONTACTS) {
                    attendee.isInContactRepository().refresh();
                    attendee.getEMail().refresh();
                } else if (property == Contact.PROP_NAME) {
                    attendee.isInContactRepository().refresh();
                    attendee.getEMail().refresh();
                } else if (property == Contact.PROP_E_MAIL) {
                    attendee.getEMail().refresh();
                }
            }
        };
        this.base.attach(this.listener);
        this.contacts.attach(this.listener);
    }

    public org.eclipse.sapphire.samples.calendar.IAttendee getBase() {
        return this.base;
    }

    protected PropertyBinding createBinding(Property property) {
        PropertyDef pdef = property.definition();
        if (pdef == IAttendee.PROP_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return AttendeeResource.this.getBase().getName().text(false);
                }

                public void write(String value) {
                    AttendeeResource.this.getBase().setName(value);
                }
            };
        }
        if (pdef == IAttendee.PROP_TYPE) {
            return new ValuePropertyBinding(){

                public String read() {
                    return AttendeeResource.this.getBase().getType().text(false);
                }

                public void write(String value) {
                    AttendeeResource.this.getBase().setType(value);
                }
            };
        }
        if (pdef == IAttendee.PROP_E_MAIL) {
            return new ValuePropertyBinding(){

                public String read() {
                    Contact c = AttendeeResource.this.findContactRecord(false);
                    return c != null ? c.getEMail().text() : null;
                }

                public void write(String value) {
                    Contact c = AttendeeResource.this.findContactRecord(value != null);
                    if (c != null) {
                        c.setEMail(value);
                    }
                }
            };
        }
        if (pdef == IAttendee.PROP_IN_CONTACT_REPOSITORY) {
            return new ValuePropertyBinding(){

                public String read() {
                    return AttendeeResource.this.findContactRecord(false) != null ? Boolean.TRUE.toString() : null;
                }

                public void write(String value) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return null;
    }

    private Contact findContactRecord(boolean createIfNecessary) {
        Contact c = null;
        String name = this.base.getName().text();
        if (name != null) {
            for (Contact contact : this.contacts.getContacts()) {
                if (!name.equals(contact.getName().text())) continue;
                c = contact;
                break;
            }
            if (c == null && createIfNecessary) {
                c = (Contact)this.contacts.getContacts().insert();
                c.setName(name);
            }
            for (Contact contact : this.contacts.getContacts()) {
                contact.attach(this.listener);
            }
        }
        return c;
    }

    public <A> A adapt(Class<A> adapterType) {
        Object res = super.adapt(adapterType);
        if (res == null) {
            res = this.base.adapt(adapterType);
        }
        return (A)res;
    }

    public void dispose() {
        super.dispose();
        this.base.detach(this.listener);
        this.contacts.detach(this.listener);
    }
}

