/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.sdk.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.java.JavaTypeReferenceService;
import org.eclipse.sapphire.java.jdt.JdtJavaType;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.ui.def.IPackageReference;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;

public final class SdkJavaTypeReferenceServiceForSdef
extends JavaTypeReferenceService {
    private IJavaProject project;

    protected void init() {
        super.init();
        this.project = JavaCore.create((IProject)((IProject)((Element)this.context(Element.class)).adapt(IProject.class)));
    }

    public JavaType resolve(String name) {
        if (name != null && name.trim().length() != 0 && !name.startsWith(".") && !name.endsWith(".")) {
            String n = name.replace('$', '.');
            try {
                IType type = this.project.findType(n);
                if (type == null && name.indexOf(46) == -1) {
                    for (IPackageReference packageRef : ((ISapphireUiDef)this.context(ISapphireUiDef.class)).getImportedPackages()) {
                        String packageName = packageRef.getName().text();
                        if (packageName != null && (type = this.project.findType(packageName, n)) != null && type.exists() && !type.isAnonymous()) break;
                    }
                }
                if (type != null) {
                    return new JdtJavaType(type);
                }
            }
            catch (JavaModelException e) {
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            }
        }
        return null;
    }

    public static final class Condition
    extends ServiceCondition {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean applicable(ServiceContext context) {
            ISapphireUiDef def = (ISapphireUiDef)context.find(ISapphireUiDef.class);
            ValueProperty property = (ValueProperty)context.find(ValueProperty.class);
            if (def == null) return false;
            if (property == null) return false;
            if (property.getTypeClass() != JavaTypeName.class) return false;
            Reference referenceAnnotation = (Reference)property.getAnnotation(Reference.class);
            if (referenceAnnotation == null) return false;
            if (referenceAnnotation.target() != JavaType.class) return false;
            IProject project = (IProject)def.adapt(IProject.class);
            if (project == null) return false;
            try {
                String[] stringArray = project.getDescription().getNatureIds();
                int n = stringArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return false;
                    }
                    String nature = stringArray[n2];
                    if (nature.equals("org.eclipse.jdt.core.javanature")) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            }
            return false;
        }
    }
}

