/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.concurrency.service;

import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.concurrency.service.TestElement;
import org.eclipse.sapphire.tests.concurrency.service.TestService;
import org.junit.Test;

public final class ServiceLookupConcurrencyTest
extends SapphireTestCase {
    @Test
    public void testPropertyServiceLookup() {
        final TestElement element = (TestElement)TestElement.TYPE.instantiate();
        Thread t1 = new Thread(){

            @Override
            public void run() {
                element.getValue().services(TestService.class);
            }
        };
        Thread t2 = new Thread(){

            @Override
            public void run() {
                int i = 0;
                while (i < 1000000) {
                    element.getValue().refresh();
                    ++i;
                }
            }
        };
        t1.start();
        t2.start();
        while (t1.isAlive() || t2.isAlive()) {
            if (t1.getState() == Thread.State.BLOCKED && t2.getState() == Thread.State.BLOCKED) {
                ServiceLookupConcurrencyTest.fail((String)"Deadlock!");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Test
    public void testElementServiceLookup() {
        final TestElement element = (TestElement)TestElement.TYPE.instantiate();
        Thread t1 = new Thread(){

            @Override
            public void run() {
                element.services(TestService.class);
            }
        };
        Thread t2 = new Thread(){

            @Override
            public void run() {
                TestElement other = (TestElement)TestElement.TYPE.instantiate();
                int i = 0;
                while (i < 1000000) {
                    element.equals(other);
                    ++i;
                }
            }
        };
        t1.start();
        t2.start();
        while (t1.isAlive() || t2.isAlive()) {
            if (t1.getState() == Thread.State.BLOCKED && t2.getState() == Thread.State.BLOCKED) {
                ServiceLookupConcurrencyTest.fail((String)"Deadlock!");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

