/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.misc.t0019;

import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.misc.t0019.TestElement;
import org.junit.Test;

public final class ModelElementClearTests
extends SapphireTestCase {
    @Test
    public void testValuePropertyClear() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            element.setStringValueProperty("abc");
            element.setIntegerValueProperty(123);
            element.getListProperty().insert();
            ModelElementClearTests.assertEquals((Object)"abc", (Object)element.getStringValueProperty().content());
            ModelElementClearTests.assertEquals((Object)123, (Object)element.getIntegerValueProperty().content());
            ModelElementClearTests.assertEquals((long)1L, (long)element.getListProperty().size());
            element.property(TestElement.PROP_STRING_VALUE_PROPERTY).clear();
            element.property(TestElement.PROP_INTEGER_VALUE_PROPERTY).clear();
            ModelElementClearTests.assertNull((Object)element.getStringValueProperty().content());
            ModelElementClearTests.assertNull((Object)element.getIntegerValueProperty().content());
            ModelElementClearTests.assertEquals((long)1L, (long)element.getListProperty().size());
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void testTransientPropertyClear() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            element.setTransientProperty((Object)this);
            element.getListProperty().insert();
            ModelElementClearTests.assertEquals((Object)((Object)this), (Object)element.getTransientProperty().content());
            ModelElementClearTests.assertEquals((long)1L, (long)element.getListProperty().size());
            element.property(TestElement.PROP_TRANSIENT_PROPERTY).clear();
            ModelElementClearTests.assertNull((Object)element.getTransientProperty().content());
            ModelElementClearTests.assertEquals((long)1L, (long)element.getListProperty().size());
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void testElementPropertyClear() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            ((TestElement.Child)element.getElementProperty().content(true)).setValueProperty("abc");
            element.getListProperty().insert();
            ModelElementClearTests.assertEquals((Object)"abc", (Object)((TestElement.Child)element.getElementProperty().content()).getValueProperty().content());
            ModelElementClearTests.assertEquals((long)1L, (long)element.getListProperty().size());
            element.property(TestElement.PROP_ELEMENT_PROPERTY).clear();
            ModelElementClearTests.assertNull((Object)element.getElementProperty().content());
            ModelElementClearTests.assertEquals((long)1L, (long)element.getListProperty().size());
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void testImpliedElementPropertyClear() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            element.getImpliedElementProperty().setValueProperty("abc");
            element.getListProperty().insert();
            ModelElementClearTests.assertEquals((Object)"abc", (Object)element.getImpliedElementProperty().getValueProperty().content());
            ModelElementClearTests.assertEquals((long)1L, (long)element.getListProperty().size());
            element.property((ElementProperty)TestElement.PROP_IMPLIED_ELEMENT_PROPERTY).clear();
            ModelElementClearTests.assertNull((Object)element.getImpliedElementProperty().getValueProperty().content());
            ModelElementClearTests.assertEquals((long)1L, (long)element.getListProperty().size());
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void testListPropertyClear() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            element.getListProperty().insert();
            element.getListProperty().insert();
            element.setStringValueProperty("abc");
            ModelElementClearTests.assertEquals((long)2L, (long)element.getListProperty().size());
            ModelElementClearTests.assertEquals((Object)"abc", (Object)element.getStringValueProperty().content());
            element.property(TestElement.PROP_LIST_PROPERTY).clear();
            ModelElementClearTests.assertEquals((long)0L, (long)element.getListProperty().size());
            ModelElementClearTests.assertEquals((Object)"abc", (Object)element.getStringValueProperty().content());
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void testAllPropertiesClear() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            element.setStringValueProperty("abc");
            element.setIntegerValueProperty(123);
            element.setTransientProperty((Object)this);
            ((TestElement.Child)element.getElementProperty().content(true)).setValueProperty("abc");
            element.getImpliedElementProperty().setValueProperty("abc");
            element.getListProperty().insert();
            element.getListProperty().insert();
            ModelElementClearTests.assertEquals((Object)"abc", (Object)element.getStringValueProperty().content());
            ModelElementClearTests.assertEquals((Object)123, (Object)element.getIntegerValueProperty().content());
            ModelElementClearTests.assertEquals((Object)((Object)this), (Object)element.getTransientProperty().content());
            ModelElementClearTests.assertEquals((Object)"abc", (Object)((TestElement.Child)element.getElementProperty().content()).getValueProperty().content());
            ModelElementClearTests.assertEquals((Object)"abc", (Object)element.getImpliedElementProperty().getValueProperty().content());
            ModelElementClearTests.assertEquals((long)2L, (long)element.getListProperty().size());
            element.clear();
            ModelElementClearTests.assertNull((Object)element.getStringValueProperty().content());
            ModelElementClearTests.assertNull((Object)element.getIntegerValueProperty().content());
            ModelElementClearTests.assertNull((Object)element.getTransientProperty().content());
            ModelElementClearTests.assertNull((Object)element.getElementProperty().content());
            ModelElementClearTests.assertNull((Object)element.getImpliedElementProperty().getValueProperty().content());
            ModelElementClearTests.assertEquals((long)0L, (long)element.getListProperty().size());
        }
        finally {
            element.dispose();
        }
    }
}

