/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.services.t0014;

import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.services.t0014.TestElement;
import org.junit.Test;

public final class DeclarativeValidationServiceTests
extends SapphireTestCase {
    @Test
    public void testDeclarativeValidationService() throws Exception {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            DeclarativeValidationServiceTests.assertValidationOk(element.getMin());
            DeclarativeValidationServiceTests.assertValidationOk(element.getMax());
            element.setMin(30);
            element.setMax(20);
            DeclarativeValidationServiceTests.assertValidationError(element.getMin(), "Must not be larger than max");
            DeclarativeValidationServiceTests.assertValidationError(element.getMax(), "Must not be smaller than min");
            element.setMax(200);
            DeclarativeValidationServiceTests.assertValidationOk(element.getMin());
            DeclarativeValidationServiceTests.assertValidationWarning(element.getMax(), "Must be less than or equal to 100");
            element.setMax(50);
            DeclarativeValidationServiceTests.assertValidationOk(element.getMin());
            DeclarativeValidationServiceTests.assertValidationOk(element.getMax());
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void testDeclarativeValidationService_MessageFunction() throws Exception {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            DeclarativeValidationServiceTests.assertValidationOk(element.getPath());
            element.setPath("abc");
            DeclarativeValidationServiceTests.assertValidationError(element.getPath(), "Path \"abc\" must start with a slash");
            element.setPath("/abc");
            DeclarativeValidationServiceTests.assertValidationOk(element.getPath());
        }
        finally {
            element.dispose();
        }
    }
}

