/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.commands;

import java.util.ArrayList;
import org.eclipse.gef.commands.Command;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.FunctionUtil;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.editor.TextPart;

public class LabelNodeCommand
extends Command {
    private TextPart textPart;
    private String labelText;

    public LabelNodeCommand(TextPart textPart, String labelText) {
        this.textPart = textPart;
        this.labelText = labelText;
    }

    public void execute() {
        DiagramNodePart nodePart = (DiagramNodePart)this.textPart.nearest(DiagramNodePart.class);
        SapphireDiagramEditorPagePart diagramPart = (SapphireDiagramEditorPagePart)nodePart.nearest(SapphireDiagramEditorPagePart.class);
        ArrayList<DiagramConnectionPart> attachedConns = new ArrayList<DiagramConnectionPart>();
        ArrayList<DiagramConnectionPart> attachedConns2 = new ArrayList<DiagramConnectionPart>();
        for (DiagramConnectionPart connPart : diagramPart.getConnections()) {
            if (!connPart.removable()) continue;
            if (connPart.getEndpoint1() == nodePart.getLocalModelElement()) {
                attachedConns.add(connPart);
            }
            if (connPart.getEndpoint2() != nodePart.getLocalModelElement()) continue;
            attachedConns2.add(connPart);
        }
        Value prop = FunctionUtil.getFunctionProperty((Element)this.textPart.getLocalModelElement(), (FunctionResult)this.textPart.getContentFunction());
        prop.write((Object)this.labelText);
        for (DiagramConnectionPart connPart : attachedConns) {
            connPart.reconnect(nodePart, diagramPart.getDiagramNodePart(connPart.getEndpoint2()));
        }
        for (DiagramConnectionPart connPart : attachedConns2) {
            connPart.reconnect(diagramPart.getDiagramNodePart(connPart.getEndpoint1()), nodePart);
        }
    }
}

