/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.figures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sapphire.ui.swt.gef.figures.BezierPoint;
import org.eclipse.sapphire.ui.swt.gef.figures.FigureUtil;
import org.eclipse.swt.graphics.Path;

public class DiagramConnectionFigure
extends PolylineConnection {
    private int generalBezierDistance = 15;

    public void setGeneralBezierDistance(int bezierDistance) {
        this.generalBezierDistance = bezierDistance;
    }

    protected int getGeneralBezierDistance() {
        return this.generalBezierDistance;
    }

    protected List<BezierPoint> getBezierPoints(PointList points, double zoom) {
        ArrayList<BezierPoint> ret = new ArrayList<BezierPoint>(points.size());
        int i = 0;
        while (i < points.size()) {
            int bezierDistance = (int)((double)this.getGeneralBezierDistance() * zoom);
            Point point = points.getPoint(i);
            ret.add(new BezierPoint(point.x, point.y, bezierDistance, bezierDistance));
            ++i;
        }
        return ret;
    }

    private Path createPath(Rectangle outerBoundss, Graphics graphics) {
        PointList points = FigureUtil.getAdjustedPointList(this.getPoints(), 1.0, 1.0);
        List<BezierPoint> bezierPoints = this.getBezierPoints(points, 1.0);
        boolean isClosed = bezierPoints.get(0).equals(bezierPoints.get(bezierPoints.size() - 1));
        Path path = FigureUtil.getBezierPath(bezierPoints, isClosed);
        return path;
    }

    protected void outlineShape(Graphics graphics) {
        graphics.setAntialias(1);
        int lineWidth = this.getLineWidth();
        int oldLineWidth = graphics.getLineWidth();
        graphics.setLineWidth(lineWidth);
        Rectangle pathbounds = this.getBounds();
        Path path = this.createPath(pathbounds, graphics);
        graphics.drawPath(path);
        path.dispose();
        graphics.setLineWidth(oldLineWidth);
    }
}

