/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.RequiredConstraintService;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ValidationService;

public final class RequiredConstraintValidationService
extends ValidationService {
    @Text(value="{0} must be specified")
    private static LocalizableText message;
    private Property property;
    private RequiredConstraintService requiredConstraintService;
    private Listener listener;

    static {
        LocalizableText.init(RequiredConstraintValidationService.class);
    }

    @Override
    protected void initValidationService() {
        this.property = this.context(Property.class);
        this.requiredConstraintService = this.property.service(RequiredConstraintService.class);
        this.listener = new Listener(){

            @Override
            public void handle(Event event) {
                RequiredConstraintValidationService.this.refresh();
            }
        };
        this.requiredConstraintService.attach(this.listener);
    }

    @Override
    protected Status compute() {
        if (!this.requiredConstraintService.required() || this.check()) {
            return Status.createOkStatus();
        }
        String msg = message.format(this.property.definition().getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false));
        return Status.createErrorStatus(msg);
    }

    protected boolean check() {
        if (this.property instanceof Value) {
            return ((Value)this.property).text() != null;
        }
        if (this.property instanceof ElementHandle) {
            return ((ElementHandle)this.property).content() != null;
        }
        throw new IllegalStateException();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.requiredConstraintService.detach(this.listener);
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            Property property = context.find(Property.class);
            return property != null && property.service(RequiredConstraintService.class) != null;
        }
    }
}

