/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.calendar.ui;

import java.util.List;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.samples.calendar.integrated.CalendarEditor;
import org.eclipse.sapphire.samples.calendar.integrated.IAttendee;
import org.eclipse.sapphire.samples.contacts.Contact;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireEditorPagePart;
import org.eclipse.sapphire.ui.forms.JumpActionHandler;
import org.eclipse.sapphire.ui.forms.MasterDetailsContentNodePart;
import org.eclipse.sapphire.ui.forms.MasterDetailsContentOutline;
import org.eclipse.sapphire.ui.forms.MasterDetailsEditorPagePart;

public final class ContactDetailsJumpHandler
extends JumpActionHandler {
    protected void initDependencies(List<String> dependencies) {
        super.initDependencies(dependencies);
        dependencies.add(IAttendee.PROP_IN_CONTACT_REPOSITORY.name());
    }

    protected boolean computeEnablementState() {
        if (super.computeEnablementState()) {
            IAttendee attendee = (IAttendee)this.getModelElement();
            return (Boolean)attendee.isInContactRepository().content();
        }
        return false;
    }

    protected Object run(Presentation context) {
        CalendarEditor editor = (CalendarEditor)((Object)context.part().nearest(CalendarEditor.class));
        ContactDetailsJumpHandler.jump(editor, this.getModelElement());
        return null;
    }

    public static void jump(CalendarEditor editor, Element modelElement) {
        IAttendee attendee = (IAttendee)modelElement;
        String name = attendee.getName().text();
        if (name != null) {
            MasterDetailsEditorPagePart contactsFormPage;
            MasterDetailsContentOutline outline;
            MasterDetailsContentNodePart contactNode;
            Contact contact = null;
            for (Contact c : editor.getContactRepository().getContacts()) {
                if (!name.equals(c.getName().text())) continue;
                contact = c;
                break;
            }
            if (contact != null && (contactNode = (outline = (contactsFormPage = (MasterDetailsEditorPagePart)editor.getEditorPagePart("Contacts")).outline()).getRoot().findNode((Element)contact)) != null) {
                contactNode.select();
                editor.showPage((SapphireEditorPagePart)contactsFormPage);
            }
        }
    }
}

