/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.contacts.internal;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.ImageService;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.samples.contacts.Contact;
import org.eclipse.sapphire.samples.contacts.ContactRepository;

public final class ContactRepositoryImageService
extends ImageService {
    private static final ImageData IMG_PERSON = (ImageData)ImageData.readFromClassLoader(Contact.class, (String)"Contact.png").required();
    private static final ImageData IMG_PERSON_FADED = (ImageData)ImageData.readFromClassLoader(Contact.class, (String)"ContactFaded.png").required();
    private Listener listener;

    protected void initImageService() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                ContactRepositoryImageService.this.refresh();
            }
        };
        ((Element)this.context(Element.class)).attach(this.listener, "Contacts/EMail");
    }

    protected ImageData compute() {
        boolean foundContactWithEMail = false;
        for (Contact contact : ((ContactRepository)this.context(ContactRepository.class)).getContacts()) {
            if (contact.getEMail().content() == null) continue;
            foundContactWithEMail = true;
            break;
        }
        return foundContactWithEMail ? IMG_PERSON : IMG_PERSON_FADED;
    }

    public void dispose() {
        super.dispose();
        ((Element)this.context(Element.class)).detach(this.listener, "Contacts/EMail");
    }
}

