/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.sdk.extensibility;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.LongString;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.annotations.Whitespace;
import org.eclipse.sapphire.modeling.localization.Localizable;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

@Label(standard="function")
@Image(path="FunctionDef.png")
public interface FunctionDef
extends Element {
    public static final ElementType TYPE = new ElementType(FunctionDef.class);
    @Label(standard="name")
    @Required
    @XmlBinding(path="name")
    @Documentation(content="The name by which function will be referenced in the expression language. Functions can be placed in a namespace by using \"[namespace]:[name]\" syntax. Hierarchical namespaces are also alowed. Each segment in the function name must follow Java identifier rules.")
    public static final ValueProperty PROP_NAME = new ValueProperty(TYPE, "Name");
    @Type(base=Signature.class)
    @Label(standard="signature")
    @XmlElementBinding(path="")
    @Documentation(content="A function can be restricted to apply to a specific parameter signature. If not restricted, the function will apply for any number of parameters. The function is responsible for throwing a FunctionExeption during evaluation if a problem with the parameters is detected.")
    public static final ElementProperty PROP_SIGNATURE = new ElementProperty(TYPE, "Signature");
    @LongString
    @Label(standard="description")
    @Localizable
    @Whitespace(collapse=true)
    @XmlBinding(path="description")
    @Documentation(content="Provides detailed information about the function. The description should be in the form of properly capitalized and punctuated sentences.")
    public static final ValueProperty PROP_DESCRIPTION = new ValueProperty(TYPE, "Description");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @Label(standard="implementation class")
    @Required
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"org.eclipse.sapphire.modeling.el.Function"})
    @MustExist
    @XmlBinding(path="impl")
    @Documentation(content="The function implementation. Must extend Function.")
    public static final ValueProperty PROP_IMPL_CLASS = new ValueProperty(TYPE, "ImplClass");

    public Value<String> getName();

    public void setName(String var1);

    public ElementHandle<Signature> getSignature();

    public Value<String> getDescription();

    public void setDescription(String var1);

    public ReferenceValue<JavaTypeName, JavaType> getImplClass();

    public void setImplClass(String var1);

    public void setImplClass(JavaTypeName var1);

    @Label(standard="signature")
    @XmlBinding(path="signature")
    public static interface Signature
    extends Element {
        public static final ElementType TYPE = new ElementType(Signature.class);
        @Type(base=Parameter.class)
        @Label(standard="parameters")
        @XmlListBinding(path="")
        public static final ListProperty PROP_PARAMETERS = new ListProperty(TYPE, "Parameters");

        public ElementList<Parameter> getParameters();

        @Label(standard="parameter")
        @XmlBinding(path="parameter")
        public static interface Parameter
        extends Element {
            public static final ElementType TYPE = new ElementType(Parameter.class);
            @Type(base=JavaTypeName.class)
            @Reference(target=JavaType.class)
            @Label(standard="parameter type")
            @Required
            @MustExist
            @XmlBinding(path="")
            @Documentation(content="The function parameter type.")
            public static final ValueProperty PROP_TYPE = new ValueProperty(TYPE, "Type");

            public ReferenceValue<JavaTypeName, JavaType> getType();

            public void setType(String var1);

            public void setType(JavaTypeName var1);
        }
    }
}

