/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.sdk.xml.schema.normalizer.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PropertyVisitor;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.FileResourceStore;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.UrlResourceStore;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.xml.XmlAttribute;
import org.eclipse.sapphire.modeling.xml.XmlComment;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.sdk.xml.schema.normalizer.CreateNormalizedXmlSchemaOp;
import org.eclipse.sapphire.sdk.xml.schema.normalizer.internal.PersistedState;
import org.eclipse.sapphire.sdk.xml.schema.normalizer.internal.PersistedStateManager;
import org.eclipse.sapphire.util.SetFactory;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CreateNormalizedXmlSchemaOpMethods {
    private static final String NS_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    @Text(value="Creating normalized XML schema file...")
    private static LocalizableText executeTaskName;

    static {
        LocalizableText.init(CreateNormalizedXmlSchemaOpMethods.class);
    }

    public static Status execute(CreateNormalizedXmlSchemaOp operation, ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new ProgressMonitor();
        }
        monitor.beginTask(executeTaskName.text(), 2);
        try {
            Path sourceSchemaFilePath;
            block41: {
                sourceSchemaFilePath = (Path)operation.getSourceFile().content();
                PersistedState state = PersistedStateManager.load(sourceSchemaFilePath);
                if (state != null) {
                    try {
                        try {
                            state.getRootElements().copy((Element)operation);
                            state.getExclusions().copy((Element)operation);
                            state.getTypeSubstitutions().copy((Element)operation);
                            state.getSortSequenceContent().copy((Element)operation);
                            state.getRemoveWildcards().copy((Element)operation);
                            state.resource().save();
                        }
                        catch (ResourceStoreException resourceStoreException) {
                            state.dispose();
                            break block41;
                        }
                    }
                    catch (Throwable throwable) {
                        state.dispose();
                        throw throwable;
                    }
                    state.dispose();
                }
            }
            IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
            IFile sourceSchemaFile = wsroot.getFile(PathBridge.create((Path)sourceSchemaFilePath));
            IFile targetSchemaFile = (IFile)operation.getFile().resolve();
            try {
                InputStream sourceSchemaFileInputStream = sourceSchemaFile.getContents();
                try {
                    targetSchemaFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    CreateNormalizedXmlSchemaOpMethods.create(targetSchemaFile.getParent());
                    if (targetSchemaFile.exists()) {
                        targetSchemaFile.setContents(sourceSchemaFileInputStream, 1, null);
                    } else {
                        targetSchemaFile.create(sourceSchemaFileInputStream, 1, null);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        sourceSchemaFileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    sourceSchemaFileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            catch (CoreException e) {
                Status status = StatusBridge.create((IStatus)e.getStatus());
                monitor.done();
                return status;
            }
            monitor.worked(1);
            try {
                WorkspaceFileResourceStore fileResourceStore = new WorkspaceFileResourceStore(targetSchemaFile);
                XmlResourceStore xmlResourceStore = new XmlResourceStore((ByteArrayResourceStore)fileResourceStore);
                XmlElement root = new XmlElement(xmlResourceStore, xmlResourceStore.getDomDocument().getDocumentElement());
                String targetNamespace = root.getAttributeText("targetNamespace");
                String targetNamespacePrefix = null;
                for (XmlAttribute attribute : root.getAttributes()) {
                    String name = attribute.getDomNode().getName();
                    String value = attribute.getText();
                    if (!name.startsWith("xmlns:") || !value.equals(targetNamespace)) continue;
                    targetNamespacePrefix = name.substring(6);
                }
                HashSet<String> included = new HashSet<String>();
                included.add(sourceSchemaFile.getLocation().toOSString());
                while (CreateNormalizedXmlSchemaOpMethods.inlineIncludes(root, sourceSchemaFile.getParent().getLocation().toOSString(), included)) {
                }
                CreateNormalizedXmlSchemaOpMethods.removeComments(root);
                CreateNormalizedXmlSchemaOpMethods.removeAnnotations(root);
                CreateNormalizedXmlSchemaOpMethods.removeDefaultMinMaxOccurs(root);
                if (((Boolean)operation.getRemoveWildcards().content()).booleanValue()) {
                    CreateNormalizedXmlSchemaOpMethods.removeWildcards(root);
                }
                CreateNormalizedXmlSchemaOpMethods.exclude(root, operation.getExclusions());
                HashMap<String, XmlElement> types = new HashMap<String, XmlElement>();
                HashMap<String, XmlElement> elements = new HashMap<String, XmlElement>();
                HashMap<String, XmlElement> groups = new HashMap<String, XmlElement>();
                for (XmlElement element : root.getChildElements()) {
                    Object gname;
                    String elname = element.getLocalName();
                    if (elname.equals("simpleType") || elname.equals("complexType")) {
                        String tname = element.getAttributeText("name");
                        if (tname.length() <= 0) continue;
                        if (targetNamespacePrefix != null) {
                            tname = String.valueOf(targetNamespacePrefix) + ":" + tname;
                        }
                        if (types.containsKey(tname)) {
                            element.remove();
                            continue;
                        }
                        types.put(tname, element);
                        continue;
                    }
                    if (elname.equals("element")) {
                        String ename = element.getAttributeText("name");
                        if (ename.length() <= 0) continue;
                        if (targetNamespacePrefix != null) {
                            ename = String.valueOf(targetNamespacePrefix) + ":" + ename;
                        }
                        if (elements.containsKey(ename)) {
                            element.remove();
                            continue;
                        }
                        elements.put(ename, element);
                        continue;
                    }
                    if (!elname.equals("group") || ((String)(gname = element.getAttributeText("name"))).length() <= 0) continue;
                    if (targetNamespacePrefix != null) {
                        gname = String.valueOf(targetNamespacePrefix) + ":" + (String)gname;
                    }
                    if (groups.containsKey(gname)) {
                        element.remove();
                        continue;
                    }
                    groups.put((String)gname, element);
                }
                CreateNormalizedXmlSchemaOpMethods.changeSchemaNamespacePrefix(root.getDomNode().getOwnerDocument(), "xsd");
                HashMap<String, String> typeSubstitutions = new HashMap<String, String>();
                for (CreateNormalizedXmlSchemaOp.TypeSubstitution sub : operation.getTypeSubstitutions()) {
                    typeSubstitutions.put((String)sub.getBefore().content(), (String)sub.getAfter().content());
                }
                CreateNormalizedXmlSchemaOpMethods.applyTypeSubstitutions(root, typeSubstitutions);
                boolean keepInlining = true;
                while (keepInlining) {
                    boolean bl = keepInlining = CreateNormalizedXmlSchemaOpMethods.inlineRestriction(root) || CreateNormalizedXmlSchemaOpMethods.inlineExtension(root) || CreateNormalizedXmlSchemaOpMethods.inlineSequenceInSequence(root) || CreateNormalizedXmlSchemaOpMethods.inlineSequenceInChoice(root) || CreateNormalizedXmlSchemaOpMethods.inlineTypes(root, types, SetFactory.empty()) || CreateNormalizedXmlSchemaOpMethods.inlineElements(root, elements, SetFactory.empty()) || CreateNormalizedXmlSchemaOpMethods.inlineGroups(root, groups, SetFactory.empty()) || CreateNormalizedXmlSchemaOpMethods.removeRedundantMinMaxOccursInChoice(root);
                }
                for (XmlElement element : root.getChildElements()) {
                    String elname = element.getLocalName();
                    if (!elname.equals("simpleType") && !elname.equals("complexType") && !elname.equals("group")) continue;
                    element.remove();
                }
                if (!operation.getRootElements().empty()) {
                    final SetFactory rootsFactory = SetFactory.start();
                    operation.visit("RootElements/Name", new PropertyVisitor(){

                        public boolean visit(Value<?> property) {
                            rootsFactory.add((Object)property.text());
                            return true;
                        }
                    });
                    Set roots = rootsFactory.result();
                    for (XmlElement element : root.getChildElements()) {
                        String elname = element.getLocalName();
                        if (!elname.equals("element") || roots.contains(element.getAttributeText("name"))) continue;
                        element.remove();
                    }
                }
                CreateNormalizedXmlSchemaOpMethods.sortChoiceContent(root);
                CreateNormalizedXmlSchemaOpMethods.sortElementContent(root);
                if (((Boolean)operation.getSortSequenceContent().content()).booleanValue()) {
                    CreateNormalizedXmlSchemaOpMethods.sortSequenceContent(root);
                }
                CreateNormalizedXmlSchemaOpMethods.sort(root);
                root.format();
                xmlResourceStore.save();
            }
            catch (ResourceStoreException e) {
                Status status = Status.createErrorStatus((Throwable)e);
                monitor.done();
                return status;
            }
        }
        finally {
            monitor.done();
        }
        return Status.createOkStatus();
    }

    private static void create(IContainer container) throws CoreException {
        if (!container.exists()) {
            CreateNormalizedXmlSchemaOpMethods.create(container.getParent());
            IFolder iFolder = (IFolder)container;
            iFolder.create(true, true, null);
        }
    }

    private static boolean inlineIncludes(XmlElement root, String context, Set<String> included) {
        boolean changed = false;
        org.w3c.dom.Element rootDomNode = root.getDomNode();
        Document document = rootDomNode.getOwnerDocument();
        for (XmlElement includeElement : root.getChildElements("include")) {
            org.w3c.dom.Element includeElementDomNode = includeElement.getDomNode();
            String includedSchemaLocation = includeElement.getAttributeText("schemaLocation");
            if (!includedSchemaLocation.startsWith("http://")) {
                includedSchemaLocation = String.valueOf(context) + "/" + includedSchemaLocation;
            }
            try {
                Object includedSchemaResourceStore = includedSchemaLocation.startsWith("http://") ? new UrlResourceStore(new URL(includedSchemaLocation)) : new FileResourceStore(new File(includedSchemaLocation));
                XmlResourceStore xmlResourceStore = new XmlResourceStore((ByteArrayResourceStore)includedSchemaResourceStore);
                XmlElement includedSchemaRoot = new XmlElement(xmlResourceStore, xmlResourceStore.getDomDocument().getDocumentElement());
                for (XmlElement includedSchemaElement : includedSchemaRoot.getChildElements()) {
                    org.w3c.dom.Element inlinedDomNode = (org.w3c.dom.Element)document.importNode(includedSchemaElement.getDomNode(), true);
                    rootDomNode.insertBefore(inlinedDomNode, includeElementDomNode);
                }
                includeElement.remove();
                changed = true;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (ResourceStoreException e) {
                e.printStackTrace();
            }
        }
        return changed;
    }

    private static void removeComments(XmlElement element) {
        for (XmlComment comment : element.getComments()) {
            comment.remove();
        }
        for (XmlElement x : element.getChildElements()) {
            CreateNormalizedXmlSchemaOpMethods.removeComments(x);
        }
    }

    private static void removeAnnotations(XmlElement element) {
        for (XmlElement x : element.getChildElements("annotation")) {
            x.remove();
        }
        for (XmlElement x : element.getChildElements()) {
            CreateNormalizedXmlSchemaOpMethods.removeAnnotations(x);
        }
    }

    private static void removeDefaultMinMaxOccurs(XmlElement element) {
        for (XmlElement x : element.getChildElements()) {
            if (x.getAttributeText("minOccurs").equals("1")) {
                x.setAttributeText("minOccurs", null, true);
            }
            if (x.getAttributeText("maxOccurs").equals("1")) {
                x.setAttributeText("maxOccurs", null, true);
            }
            CreateNormalizedXmlSchemaOpMethods.removeDefaultMinMaxOccurs(x);
        }
    }

    private static void removeWildcards(XmlElement element) {
        for (XmlElement x : element.getChildElements("anyAttribute")) {
            x.remove();
        }
        for (XmlElement x : element.getChildElements("any")) {
            x.remove();
        }
        for (XmlElement x : element.getChildElements()) {
            CreateNormalizedXmlSchemaOpMethods.removeWildcards(x);
        }
    }

    private static void exclude(XmlElement element, List<CreateNormalizedXmlSchemaOp.Exclusion> exclusions) {
        for (CreateNormalizedXmlSchemaOp.Exclusion exclusion : exclusions) {
            CreateNormalizedXmlSchemaOpMethods.exclude(element, exclusion);
        }
    }

    private static void exclude(XmlElement element, CreateNormalizedXmlSchemaOp.Exclusion exclusion) {
        if (exclusion.getType().content() == CreateNormalizedXmlSchemaOp.Exclusion.ExclusionType.ATTRIBUTE) {
            CreateNormalizedXmlSchemaOpMethods.excludeAttributes(element, (String)exclusion.getName().content());
        } else {
            CreateNormalizedXmlSchemaOpMethods.excludeElements(element, (String)exclusion.getName().content());
        }
    }

    private static void excludeAttributes(XmlElement element, String name) {
        for (XmlElement x : element.getChildElements()) {
            if (x.getLocalName().equals("attribute") && (name.equals(x.getAttributeText("name")) || name.equals(x.getAttributeText("ref")))) {
                x.remove();
                continue;
            }
            CreateNormalizedXmlSchemaOpMethods.excludeAttributes(x, name);
        }
    }

    private static void excludeElements(XmlElement element, String name) {
        for (XmlElement x : element.getChildElements()) {
            if (x.getLocalName().equals("element") && (name.equals(x.getAttributeText("name")) || name.equals(x.getAttributeText("ref")))) {
                x.remove();
                continue;
            }
            CreateNormalizedXmlSchemaOpMethods.excludeElements(x, name);
        }
    }

    private static boolean inlineRestriction(XmlElement element) {
        boolean changed = false;
        for (XmlElement x : element.getChildElements()) {
            String base;
            XmlElement complexTypeElement;
            XmlElement simpleContentElement;
            XmlElement restrictionElement;
            if (x.getLocalName().equals("element") && (restrictionElement = CreateNormalizedXmlSchemaOpMethods.getSoleChildElement(simpleContentElement = CreateNormalizedXmlSchemaOpMethods.getSoleChildElement(complexTypeElement = CreateNormalizedXmlSchemaOpMethods.getSoleChildElement(x, "complexType"), "simpleContent"), "restriction")) != null && restrictionElement.getChildElements().isEmpty() && (base = restrictionElement.getAttributeText("base")).length() > 0) {
                x.setAttributeText("type", base, false);
                complexTypeElement.remove();
                changed = true;
            }
            if (!CreateNormalizedXmlSchemaOpMethods.inlineRestriction(x)) continue;
            changed = true;
        }
        return changed;
    }

    private static boolean inlineExtension(XmlElement element) {
        boolean changed = false;
        for (XmlElement x : element.getChildElements()) {
            String base;
            XmlElement complexTypeElement;
            XmlElement simpleContentElement;
            XmlElement extensionElement;
            if (x.getLocalName().equals("element") && (extensionElement = CreateNormalizedXmlSchemaOpMethods.getSoleChildElement(simpleContentElement = CreateNormalizedXmlSchemaOpMethods.getSoleChildElement(complexTypeElement = CreateNormalizedXmlSchemaOpMethods.getSoleChildElement(x, "complexType"), "simpleContent"), "extension")) != null && extensionElement.getChildElements().isEmpty() && (base = extensionElement.getAttributeText("base")).length() > 0) {
                x.setAttributeText("type", base, false);
                complexTypeElement.remove();
                changed = true;
            }
            if (!CreateNormalizedXmlSchemaOpMethods.inlineExtension(x)) continue;
            changed = true;
        }
        return changed;
    }

    private static boolean inlineSequenceInSequence(XmlElement element) {
        boolean changed = false;
        if (element.getLocalName().equals("sequence")) {
            org.w3c.dom.Element elementDomNode = element.getDomNode();
            for (XmlElement child : element.getChildElements()) {
                org.w3c.dom.Element childDomNode = child.getDomNode();
                if (!child.getLocalName().equals("sequence") || child.getAttributes().size() != 0) continue;
                for (XmlElement grandchild : child.getChildElements()) {
                    elementDomNode.insertBefore(grandchild.getDomNode(), childDomNode);
                }
                child.remove();
                changed = true;
            }
        }
        for (XmlElement child : element.getChildElements()) {
            if (!CreateNormalizedXmlSchemaOpMethods.inlineSequenceInSequence(child)) continue;
            changed = true;
        }
        return changed;
    }

    private static boolean inlineSequenceInChoice(XmlElement element) {
        boolean changed = false;
        if (element.getLocalName().equals("choice") && element.getAttributeText("maxOccurs").equals("unbounded") && element.getAttributeText("minOccurs").equals("0")) {
            org.w3c.dom.Element elementDomNode = element.getDomNode();
            for (XmlElement child : element.getChildElements()) {
                org.w3c.dom.Element childDomNode = child.getDomNode();
                if (!child.getLocalName().equals("sequence") || child.getAttributes().size() != 0) continue;
                boolean doit = false;
                for (XmlElement grandchild : child.getChildElements()) {
                    if (!grandchild.getAttributeText("maxOccurs").equals("unbounded") || !grandchild.getAttributeText("minOccurs").equals("0")) continue;
                    doit = true;
                    break;
                }
                if (!doit) continue;
                for (XmlElement grandchild : child.getChildElements()) {
                    grandchild.setAttributeText("maxOccurs", null, true);
                    grandchild.setAttributeText("minOccurs", null, true);
                    elementDomNode.insertBefore(grandchild.getDomNode(), childDomNode);
                }
                child.remove();
                changed = true;
            }
        }
        for (XmlElement child : element.getChildElements()) {
            if (!CreateNormalizedXmlSchemaOpMethods.inlineSequenceInChoice(child)) continue;
            changed = true;
        }
        return changed;
    }

    private static boolean inlineTypes(XmlElement element, Map<String, XmlElement> types, Set<String> inlined) {
        boolean changed = false;
        for (XmlElement x : element.getChildElements()) {
            XmlElement type;
            String tname = null;
            if (x.getLocalName().equals("element") && (tname = x.getAttributeText("type")).length() > 0 && (type = types.get(tname)) != null) {
                x.setAttributeText("type", null, true);
                if (!inlined.contains(tname)) {
                    org.w3c.dom.Element xdom = x.getDomNode();
                    org.w3c.dom.Element tdom = (org.w3c.dom.Element)xdom.getOwnerDocument().importNode(type.getDomNode(), true);
                    tdom.removeAttribute("name");
                    xdom.insertBefore(tdom, null);
                    changed = true;
                }
            }
            if (!CreateNormalizedXmlSchemaOpMethods.inlineTypes(x, types, SetFactory.start().add(inlined).add((Object)tname).result())) continue;
            changed = true;
        }
        return changed;
    }

    private static boolean inlineElements(XmlElement element, Map<String, XmlElement> elements, Set<String> inlined) {
        boolean changed = false;
        org.w3c.dom.Element elementDomNode = element.getDomNode();
        Document document = elementDomNode.getOwnerDocument();
        for (XmlElement x : element.getChildElements()) {
            XmlElement reftarget;
            String ename = null;
            if (x.getLocalName().equals("element") && (ename = x.getAttributeText("ref")).length() > 0 && (reftarget = elements.get(ename)) != null) {
                x.setAttributeText("ref", null, true);
                if (!inlined.contains(ename)) {
                    org.w3c.dom.Element xdom = x.getDomNode();
                    for (XmlElement refTargetContentElement : reftarget.getChildElements()) {
                        org.w3c.dom.Element idom = (org.w3c.dom.Element)document.importNode(refTargetContentElement.getDomNode(), true);
                        xdom.insertBefore(idom, null);
                    }
                    x.setAttributeText("name", reftarget.getAttributeText("name"), false);
                    x.setAttributeText("type", reftarget.getAttributeText("type"), false);
                    changed = true;
                }
            }
            if (!CreateNormalizedXmlSchemaOpMethods.inlineElements(x, elements, SetFactory.start().add(inlined).add((Object)ename).result())) continue;
            changed = true;
        }
        return changed;
    }

    private static boolean inlineGroups(XmlElement element, Map<String, XmlElement> groups, Set<String> inlined) {
        boolean changed = false;
        org.w3c.dom.Element elementDomNode = element.getDomNode();
        Document document = elementDomNode.getOwnerDocument();
        for (XmlElement x : element.getChildElements()) {
            if (x.getLocalName().equals("group")) {
                XmlElement group;
                String gname = x.getAttributeText("ref");
                if (gname.length() <= 0 || (group = groups.get(gname)) == null) continue;
                boolean repeat = inlined.contains(gname);
                org.w3c.dom.Element xdom = x.getDomNode();
                for (XmlElement groupContentElement : group.getChildElements()) {
                    org.w3c.dom.Element gdom = (org.w3c.dom.Element)document.importNode(groupContentElement.getDomNode(), !repeat);
                    elementDomNode.insertBefore(gdom, xdom);
                    if (repeat) continue;
                    CreateNormalizedXmlSchemaOpMethods.inlineGroups(element.getChildElement(gdom), groups, SetFactory.start().add(inlined).add((Object)gname).result());
                }
                elementDomNode.removeChild(xdom);
                changed = true;
                continue;
            }
            if (!CreateNormalizedXmlSchemaOpMethods.inlineGroups(x, groups, inlined)) continue;
            changed = true;
        }
        return changed;
    }

    private static boolean removeRedundantMinMaxOccursInChoice(XmlElement element) {
        boolean changed = false;
        if (element.getLocalName().equals("choice") && element.getAttributeText("maxOccurs").equals("unbounded") && element.getAttributeText("minOccurs").equals("0")) {
            for (XmlElement child : element.getChildElements()) {
                if (child.getAttributeText("maxOccurs").equals("unbounded")) {
                    child.setAttributeText("maxOccurs", null, true);
                    changed = true;
                }
                if (!child.getAttributeText("minOccurs").equals("0")) continue;
                child.setAttributeText("minOccurs", null, true);
                changed = true;
            }
        }
        for (XmlElement child : element.getChildElements()) {
            if (!CreateNormalizedXmlSchemaOpMethods.removeRedundantMinMaxOccursInChoice(child)) continue;
            changed = true;
        }
        return changed;
    }

    private static boolean applyTypeSubstitutions(XmlElement element, Map<String, String> typeSubstitutions) {
        boolean changed = false;
        if (CreateNormalizedXmlSchemaOpMethods.applyTypeSubstitutions(element, "type", typeSubstitutions)) {
            changed = true;
        }
        if (CreateNormalizedXmlSchemaOpMethods.applyTypeSubstitutions(element, "base", typeSubstitutions)) {
            changed = true;
        }
        for (XmlElement child : element.getChildElements()) {
            if (!CreateNormalizedXmlSchemaOpMethods.applyTypeSubstitutions(child, typeSubstitutions)) continue;
            changed = true;
        }
        return changed;
    }

    private static boolean applyTypeSubstitutions(XmlElement element, String attribute, Map<String, String> typeSubstitutions) {
        String after;
        boolean changed = false;
        String before = element.getAttributeText(attribute);
        if (before.length() > 0 && (after = typeSubstitutions.get(before)) != null) {
            element.setAttributeText(attribute, after, false);
            changed = true;
        }
        return changed;
    }

    private static void sortChoiceContent(XmlElement element) {
        if (element.getLocalName().equals("choice")) {
            CreateNormalizedXmlSchemaOpMethods.sort(element, new SchemaContentComparator());
        }
        for (XmlElement child : element.getChildElements()) {
            CreateNormalizedXmlSchemaOpMethods.sortChoiceContent(child);
        }
    }

    private static void sortSequenceContent(XmlElement element) {
        if (element.getLocalName().equals("sequence")) {
            CreateNormalizedXmlSchemaOpMethods.sort(element, new SchemaContentComparator());
        }
        for (XmlElement child : element.getChildElements()) {
            CreateNormalizedXmlSchemaOpMethods.sortSequenceContent(child);
        }
    }

    private static void sortElementContent(XmlElement element) {
        if (element.getLocalName().equals("element")) {
            CreateNormalizedXmlSchemaOpMethods.sort(element, new ElementChildrenComparator());
        }
        for (XmlElement child : element.getChildElements()) {
            CreateNormalizedXmlSchemaOpMethods.sortElementContent(child);
        }
    }

    private static void sort(XmlElement element, Comparator<XmlElement> comparator) {
        ArrayList<XmlElement> children = new ArrayList<XmlElement>();
        for (XmlElement child : element.getChildElements()) {
            children.add(child);
            child.remove();
        }
        Collections.sort(children, comparator);
        org.w3c.dom.Element rootDomElement = element.getDomNode();
        for (XmlElement child : children) {
            rootDomElement.insertBefore(child.getDomNode(), null);
        }
    }

    private static void sort(XmlElement root) {
        ArrayList<XmlElement> elements = new ArrayList<XmlElement>();
        for (XmlElement x : root.getChildElements()) {
            elements.add(x);
            x.remove();
        }
        Collections.sort(elements, new SchemaContentComparator());
        org.w3c.dom.Element rootDomElement = root.getDomNode();
        for (XmlElement x : elements) {
            rootDomElement.insertBefore(x.getDomNode(), null);
        }
    }

    private static void changeSchemaNamespacePrefix(Document document, String prefix) {
        org.w3c.dom.Element root = document.getDocumentElement();
        if (root != null) {
            String newPrefix = prefix.equals("") ? null : prefix;
            NamedNodeMap attributes = root.getAttributes();
            boolean doit = false;
            String oldPrefix = null;
            int i = 0;
            int count = attributes.getLength();
            while (i < count) {
                Attr attribute = (Attr)attributes.item(i);
                String name = attribute.getName();
                String value = attribute.getValue();
                if (name.equals("xmlns") && value.equals(NS_SCHEMA)) {
                    if (newPrefix == null) break;
                    root.removeAttributeNode(attribute);
                    doit = true;
                    break;
                }
                if (name.startsWith("xmlns:") && value.equals(NS_SCHEMA)) {
                    oldPrefix = name.substring(6);
                    if (oldPrefix.equals(newPrefix)) break;
                    root.removeAttributeNode(attribute);
                    doit = true;
                    break;
                }
                ++i;
            }
            if (doit) {
                if (newPrefix == null) {
                    root.setAttribute("xmlns", NS_SCHEMA);
                } else {
                    root.setAttribute("xmlns:" + newPrefix, NS_SCHEMA);
                }
            }
            CreateNormalizedXmlSchemaOpMethods.changeSchemaNamespacePrefix(root, oldPrefix, newPrefix);
        }
    }

    private static void changeSchemaNamespacePrefix(Node node, String oldPrefix, String newPrefix) {
        org.w3c.dom.Element element;
        if (node instanceof org.w3c.dom.Element && NS_SCHEMA.equals((element = (org.w3c.dom.Element)node).getNamespaceURI())) {
            NodeList children = element.getChildNodes();
            int i = 0;
            int n = children.getLength();
            while (i < n) {
                CreateNormalizedXmlSchemaOpMethods.changeSchemaNamespacePrefix(children.item(i), oldPrefix, newPrefix);
                ++i;
            }
            element.getOwnerDocument().renameNode(element, NS_SCHEMA, String.valueOf(newPrefix == null ? "" : String.valueOf(newPrefix) + ":") + element.getLocalName());
            CreateNormalizedXmlSchemaOpMethods.changeSchemaNamespacePrefix(element, "type", oldPrefix, newPrefix);
            CreateNormalizedXmlSchemaOpMethods.changeSchemaNamespacePrefix(element, "base", oldPrefix, newPrefix);
        }
    }

    private static void changeSchemaNamespacePrefix(org.w3c.dom.Element element, String attribute, String oldPrefix, String newPrefix) {
        String type = element.getAttribute(attribute);
        if (type.length() > 0) {
            String typePrefix;
            int colon = type.indexOf(58);
            String string = typePrefix = colon == -1 ? null : type.substring(0, colon);
            if (MiscUtil.equal((Object)typePrefix, (Object)oldPrefix)) {
                String typeWithoutPrefix = colon == -1 ? type : type.substring(colon + 1);
                element.setAttribute(attribute, String.valueOf(newPrefix == null ? "" : String.valueOf(newPrefix) + ":") + typeWithoutPrefix);
            }
        }
    }

    private static XmlElement getSoleChildElement(XmlElement element, String name) {
        XmlElement child;
        List children;
        if (element != null && (children = element.getChildElements()).size() == 1 && (child = (XmlElement)children.get(0)).getLocalName().equals(name)) {
            return child;
        }
        return null;
    }

    private static final class ElementChildrenComparator
    implements Comparator<XmlElement> {
        private ElementChildrenComparator() {
        }

        @Override
        public int compare(XmlElement x, XmlElement y) {
            int result = this.bucket(x) - this.bucket(y);
            if (result == 0 && (result = x.getLocalName().compareTo(y.getLocalName())) == 0) {
                result = x.getAttributeText("name").compareTo(y.getAttributeText("name"));
            }
            return result;
        }

        private int bucket(XmlElement element) {
            String name = element.getLocalName();
            if (name.equals("simpleType") || name.equals("complexType")) {
                return 1;
            }
            if (name.equals("unique") || name.equals("key") || name.equals("keyref")) {
                return 2;
            }
            return 3;
        }
    }

    private static final class SchemaContentComparator
    implements Comparator<XmlElement> {
        private SchemaContentComparator() {
        }

        @Override
        public int compare(XmlElement x, XmlElement y) {
            int result = x.getLocalName().compareTo(y.getLocalName());
            if (result == 0) {
                result = x.getAttributeText("name").compareTo(y.getAttributeText("name"));
            }
            return result;
        }
    }
}

