/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.java.jdt.t0001;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.jdt.internal.JdtJavaTypeReferenceService;
import org.eclipse.sapphire.tests.java.jdt.JavaJdtTestCase;
import org.junit.Test;

public final class TestJavaJdt0001
extends JavaJdtTestCase {
    @Test
    public void testIsClass() throws Exception {
        IJavaProject project = this.getJavaProject();
        this.writeJavaSourceFile("foo.bar", "TestClass", "public class TestClass {}");
        JdtJavaTypeReferenceService service = new JdtJavaTypeReferenceService(project);
        JavaType type = service.resolve("foo.bar.TestClass");
        TestJavaJdt0001.assertNotNull((Object)type);
        TestJavaJdt0001.assertEquals((Object)JavaTypeKind.CLASS, (Object)type.kind());
    }

    @Test
    public void testIsAbstractClass() throws Exception {
        IJavaProject project = this.getJavaProject();
        this.writeJavaSourceFile("foo.bar", "TestAbstractClass", "public abstract class TestAbstractClass {}");
        JdtJavaTypeReferenceService service = new JdtJavaTypeReferenceService(project);
        JavaType type = service.resolve("foo.bar.TestAbstractClass");
        TestJavaJdt0001.assertNotNull((Object)type);
        TestJavaJdt0001.assertEquals((Object)JavaTypeKind.ABSTRACT_CLASS, (Object)type.kind());
    }

    @Test
    public void testIsInterface() throws Exception {
        IJavaProject project = this.getJavaProject();
        this.writeJavaSourceFile("foo.bar", "TestInterface", "public interface TestInterface {}");
        JdtJavaTypeReferenceService service = new JdtJavaTypeReferenceService(project);
        JavaType type = service.resolve("foo.bar.TestInterface");
        TestJavaJdt0001.assertNotNull((Object)type);
        TestJavaJdt0001.assertEquals((Object)JavaTypeKind.INTERFACE, (Object)type.kind());
    }

    @Test
    public void testIsAnnotation() throws Exception {
        IJavaProject project = this.getJavaProject();
        this.writeJavaSourceFile("foo.bar", "TestAnnotation", "public @interface TestAnnotation {}");
        JdtJavaTypeReferenceService service = new JdtJavaTypeReferenceService(project);
        JavaType type = service.resolve("foo.bar.TestAnnotation");
        TestJavaJdt0001.assertNotNull((Object)type);
        TestJavaJdt0001.assertEquals((Object)JavaTypeKind.ANNOTATION, (Object)type.kind());
    }

    @Test
    public void testIsEnum() throws Exception {
        IJavaProject project = this.getJavaProject();
        this.writeJavaSourceFile("foo.bar", "TestEnum", "public enum TestEnum { A, B, C }");
        JdtJavaTypeReferenceService service = new JdtJavaTypeReferenceService(project);
        JavaType type = service.resolve("foo.bar.TestEnum");
        TestJavaJdt0001.assertNotNull((Object)type);
        TestJavaJdt0001.assertEquals((Object)JavaTypeKind.ENUM, (Object)type.kind());
    }
}

