/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.misc.t0003;

import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.VersionConstraint;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.junit.Test;

public final class TestMisc0003
extends SapphireTestCase {
    @Test
    public void testSingleVersionConstraint() {
        VersionConstraint constraint = new VersionConstraint("1.2.3");
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3.0.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.4")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.3.4")));
    }

    @Test
    public void testClosedRangeVersionConstraint1() {
        VersionConstraint constraint = new VersionConstraint("[1.2.3-1.3)");
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3.0.0")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.5")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.3.0")));
    }

    @Test
    public void testClosedRangeVersionConstraint2() {
        VersionConstraint constraint = new VersionConstraint("[1.2.3-1.3]");
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3.0.0")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.5")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.3.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.3.1")));
    }

    @Test
    public void testClosedRangeVersionConstraint3() {
        VersionConstraint constraint = new VersionConstraint("(1.2.3-1.3]");
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.3.0.0")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.5")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.3.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.3.1")));
    }

    @Test
    public void testOpenRangeVersionConstraint1() {
        VersionConstraint constraint = new VersionConstraint("[1.2.3");
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("0.5.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.2")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3.0.0")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.5")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("2.0")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("55.0")));
    }

    @Test
    public void testOpenRangeVersionConstraint2() {
        VersionConstraint constraint = new VersionConstraint("(1.2.3");
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("0.5.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.2")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.3.0.0")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.5")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("2.0")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("55.0")));
    }

    @Test
    public void testOpenRangeVersionConstraint3() {
        VersionConstraint constraint = new VersionConstraint("1.2.3]");
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("0.5.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.0")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.2")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3.0.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.5")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("2.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("55.0")));
    }

    @Test
    public void testOpenRangeVersionConstraint4() {
        VersionConstraint constraint = new VersionConstraint("1.2.3)");
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("0.5.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.0")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.2")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.3.0.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.5")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("2.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("55.0")));
    }

    @Test
    public void testComplexVersionConstraint() {
        VersionConstraint constraint = new VersionConstraint("1.2.3,3.4,[5.2-6.0),[8.3");
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.1")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.4")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("3.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("3.4")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("3.4.1")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("3.5")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("5.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("5.1")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("5.2")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("5.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("5.9.9.9")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("6.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("6.1")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("7.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("8.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("8.2")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("8.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("8.3.4.5")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("8.5")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("9.0")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("55.0")));
    }

    @Test
    public void testVersionConstraintSpaceTolerance() {
        VersionConstraint constraint = new VersionConstraint("   1.2.3, 3.4  ,   [   5.2  -   6.0) ,    [  8.3    ");
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.1")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("1.2.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("1.2.4")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("3.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("3.4")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("3.4.1")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("3.5")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("5.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("5.1")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("5.2")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("5.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("5.9.9.9")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("6.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("6.1")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("7.3")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("8.0")));
        TestMisc0003.assertFalse((boolean)constraint.check(new Version("8.2")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("8.3")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("8.3.4.5")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("8.5")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("9.0")));
        TestMisc0003.assertTrue((boolean)constraint.check(new Version("55.0")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionConstraintErrorHandling01() {
        new VersionConstraint(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionConstraintErrorHandling02() {
        new VersionConstraint("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionConstraintErrorHandling03() {
        new VersionConstraint("   ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionConstraintErrorHandling04() {
        new VersionConstraint("[");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionConstraintErrorHandling05() {
        new VersionConstraint(")");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionConstraintErrorHandling06() {
        new VersionConstraint("[[1.2.3");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionConstraintErrorHandling07() {
        new VersionConstraint("1.2.3))");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionConstraintErrorHandling08() {
        new VersionConstraint("[1.2.3-");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionConstraintErrorHandling09() {
        new VersionConstraint("-1.2.3)");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionConstraintErrorHandling10() {
        new VersionConstraint("1.2.3-");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionConstraintErrorHandling11() {
        new VersionConstraint("-1.2.3");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionConstraintErrorHandling12() {
        new VersionConstraint("1.2.3-4.5.6");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionConstraintErrorHandling13() {
        new VersionConstraint(",1.2.3");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionConstraintErrorHandling14() {
        new VersionConstraint("1.2.3,");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionConstraintErrorHandling15() {
        new VersionConstraint("1.2.3,,4.5.6");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionConstraintErrorHandling16() {
        new VersionConstraint("1.2.3.");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionConstraintErrorHandling17() {
        new VersionConstraint(".1.2.3");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionConstraintErrorHandling18() {
        new VersionConstraint("1..2.3");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionConstraintErrorHandling19() {
        new VersionConstraint("1 2.3");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionConstraintErrorHandling20() {
        new VersionConstraint("1.2.3.v20120702");
    }
}

