/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.misc.t0018;

import java.util.List;
import java.util.Map;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.misc.t0018.TestChildElement;
import org.eclipse.sapphire.tests.modeling.misc.t0018.TestElement;
import org.junit.Test;

public final class TestModelingMisc0018
extends SapphireTestCase {
    @Test
    public void testRuntimeTypeCompilation() throws Exception {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            element.setStringValue("abc");
            TestModelingMisc0018.assertEquals((Object)"abc", (Object)element.getStringValue().content());
            element.setIntegerValue(1);
            TestModelingMisc0018.assertEquals((Object)1, (Object)element.getIntegerValue().content());
            element.setIntegerValue("2");
            TestModelingMisc0018.assertEquals((Object)2, (Object)element.getIntegerValue().content());
            element.setJavaTypeReferenceValue(List.class.getName());
            TestModelingMisc0018.assertSame(List.class, (Object)((JavaType)element.getJavaTypeReferenceValue().resolve()).artifact());
            element.setJavaTypeReferenceValue(new JavaTypeName(Map.class.getName()));
            TestModelingMisc0018.assertSame(Map.class, (Object)((JavaType)element.getJavaTypeReferenceValue().resolve()).artifact());
            element.setTransient(System.out);
            TestModelingMisc0018.assertSame((Object)System.out, (Object)element.getTransient().content());
            ElementList<TestChildElement> list = element.getList();
            ((TestChildElement)list.insert()).setStringValue("foo");
            ((TestChildElement)list.insert()).setStringValue("bar");
            TestModelingMisc0018.assertEquals((long)2L, (long)list.size());
            TestModelingMisc0018.assertEquals((Object)"foo", (Object)((TestChildElement)list.get(0)).getStringValue().content());
            TestModelingMisc0018.assertEquals((Object)"bar", (Object)((TestChildElement)list.get(1)).getStringValue().content());
            ((TestChildElement)element.getElement().content(true)).setStringValue("foo");
            TestModelingMisc0018.assertEquals((Object)"foo", (Object)((TestChildElement)element.getElement().content()).getStringValue().content());
            element.getImpliedElement().setStringValue("bar");
            TestModelingMisc0018.assertEquals((Object)"bar", (Object)element.getImpliedElement().getStringValue().content());
            element.method1();
            TestModelingMisc0018.assertEquals((long)2L, (long)element.method2(1, "abc", new String[]{"foo", "bar"}, null).length);
        }
        finally {
            element.dispose();
        }
    }
}

