/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.LongString;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Whitespace;
import org.eclipse.sapphire.modeling.localization.Localizable;
import org.eclipse.sapphire.modeling.xml.annotations.XmlValueBinding;

@Documentation(content="A presentation style is an abstraction that gives the user interface author some influence over how a part is presented without the part type hardcoding the alternatives. Providers of concrete presentations associate their rendering logic with registered presentation styles.")
public interface PresentationStyleDef
extends Element {
    public static final ElementType TYPE = new ElementType(PresentationStyleDef.class);
    @Label(standard="ID")
    @Required
    @XmlValueBinding(path="id")
    @Documentation(content="The identifier of the presentation style. Must be unique within the scope of all presentation styles associated with a given part type.")
    public static final ValueProperty PROP_ID = new ValueProperty(TYPE, "Id");
    @Label(standard="part type")
    @Required
    @XmlValueBinding(path="part-type")
    @Documentation(content="The part type that this presentation style should be associated with.")
    public static final ValueProperty PROP_PART_TYPE = new ValueProperty(TYPE, "PartType");
    @LongString
    @Label(standard="description")
    @Localizable
    @Whitespace(collapse=true)
    @XmlValueBinding(path="description")
    @Documentation(content="The detailed information about the presentation style. The description should be in the form of properly capitalized and punctuated sentences.")
    public static final ValueProperty PROP_DESCRIPTION = new ValueProperty(TYPE, "Description");

    public Value<String> getId();

    public void setId(String var1);

    public Value<String> getPartType();

    public void setPartType(String var1);

    public Value<String> getDescription();

    public void setDescription(String var1);
}

