/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.PropertyValidationEvent;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.PartVisibilityEvent;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.editor.ImagePart;
import org.eclipse.sapphire.ui.diagram.editor.LinePart;
import org.eclipse.sapphire.ui.diagram.editor.RectanglePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapeAddEvent;
import org.eclipse.sapphire.ui.diagram.editor.ShapeDeleteEvent;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapeReorderEvent;
import org.eclipse.sapphire.ui.diagram.editor.ShapeUpdateEvent;
import org.eclipse.sapphire.ui.diagram.editor.SpacerPart;
import org.eclipse.sapphire.ui.diagram.editor.TextChangeEvent;
import org.eclipse.sapphire.ui.diagram.editor.TextPart;
import org.eclipse.sapphire.ui.diagram.editor.ValidationMarkerPart;
import org.eclipse.sapphire.ui.diagram.shape.def.ImageDef;
import org.eclipse.sapphire.ui.diagram.shape.def.LineShapeDef;
import org.eclipse.sapphire.ui.diagram.shape.def.RectangleDef;
import org.eclipse.sapphire.ui.diagram.shape.def.ShapeDef;
import org.eclipse.sapphire.ui.diagram.shape.def.ShapeFactoryCaseDef;
import org.eclipse.sapphire.ui.diagram.shape.def.ShapeFactoryDef;
import org.eclipse.sapphire.ui.diagram.shape.def.SpacerDef;
import org.eclipse.sapphire.ui.diagram.shape.def.TextDef;
import org.eclipse.sapphire.util.CollectionsUtil;

public class ShapeFactoryPart
extends ShapePart {
    private ShapeFactoryDef shapeFactoryDef;
    private ElementList<?> list;
    private List<ShapePart> children;
    private Listener shapePropertyListener;
    private ShapePart separator;

    @Override
    protected void init() {
        super.init();
        this.shapeFactoryDef = (ShapeFactoryDef)this.definition;
        this.children = new ArrayList<ShapePart>();
        Element element = this.getModelElement();
        String propertyName = (String)this.shapeFactoryDef.getProperty().content();
        ListProperty property = (ListProperty)this.resolve(element, propertyName);
        this.list = element.property(property);
        for (Element listEntryModelElement : this.list) {
            ShapeFactoryCaseDef shapeFactoryCase = this.getShapeFactoryCase(listEntryModelElement);
            ShapePart childShapePart = this.createShapePart(shapeFactoryCase, listEntryModelElement);
            if (childShapePart == null) continue;
            this.children.add(childShapePart);
        }
        if (this.shapeFactoryDef.getSeparator().content() != null) {
            this.separator = this.createShapePart((ShapeDef)this.shapeFactoryDef.getSeparator().content(), element);
        }
        this.shapePropertyListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                if (event instanceof PropertyContentEvent) {
                    ShapeFactoryPart.this.handleModelPropertyChange(event);
                } else if (event instanceof PropertyValidationEvent) {
                    ShapeFactoryPart.this.refreshValidation();
                }
            }
        };
        this.list.attach(this.shapePropertyListener);
        this.refreshValidation();
    }

    @Override
    public List<ShapePart> getChildren() {
        return this.children;
    }

    @Override
    public List<ShapePart> getActiveChildren() {
        return this.children;
    }

    public ShapePart getSeparator() {
        return this.separator;
    }

    public ElementList<?> getModelElementList() {
        return this.list;
    }

    public void moveChild(ShapePart childPart, int newIndex) {
        int newNewIndex;
        int oldIndex = this.list.indexOf((Object)childPart.getLocalModelElement());
        this.list.detach(this.shapePropertyListener);
        int n = newNewIndex = newIndex == -1 ? this.children.size() : newIndex;
        if (oldIndex < newNewIndex) {
            int i = oldIndex;
            while (i < newNewIndex) {
                this.list.moveDown(childPart.getLocalModelElement());
                ++i;
            }
        } else {
            int i = newIndex;
            while (i < oldIndex) {
                this.list.moveUp(childPart.getLocalModelElement());
                ++i;
            }
        }
        this.list.attach(this.shapePropertyListener);
        this.children.remove(childPart);
        if (newIndex == -1) {
            this.children.add(childPart);
        } else {
            this.children.add(newIndex, childPart);
        }
        this.broadcast(new ShapeReorderEvent(this));
    }

    @Override
    public void dispose() {
        super.dispose();
        this.list.detach(this.shapePropertyListener);
        List<ShapePart> shapeParts = this.getChildren();
        for (ShapePart shapePart : shapeParts) {
            shapePart.dispose();
        }
    }

    public ShapePart getShapePart(Element element) {
        List<ShapePart> shapeParts = this.getChildren();
        for (ShapePart shapePart : shapeParts) {
            if (shapePart.getLocalModelElement() != element) continue;
            return shapePart;
        }
        return null;
    }

    @Override
    protected Status computeValidation() {
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        factory.merge(this.list.validation());
        for (SapphirePart sapphirePart : this.children) {
            if (sapphirePart instanceof ValidationMarkerPart) continue;
            factory.merge(sapphirePart.validation());
        }
        return factory.create();
    }

    private ShapeFactoryCaseDef getShapeFactoryCase(Element element) {
        for (ShapeFactoryCaseDef shapeFactoryCaseDef : this.shapeFactoryDef.getCases()) {
            JavaType type = (JavaType)shapeFactoryCaseDef.getElementType().resolve();
            Class cl = (Class)type.artifact();
            if (!cl.isAssignableFrom(element.getClass())) continue;
            return shapeFactoryCaseDef;
        }
        throw new RuntimeException();
    }

    private ShapePart createShapePart(ShapeDef shapeDef, Element modelElement) {
        ShapePart shapePart = null;
        if (shapeDef instanceof TextDef) {
            shapePart = new TextPart();
        } else if (shapeDef instanceof ImageDef) {
            shapePart = new ImagePart();
        } else if (shapeDef instanceof LineShapeDef) {
            shapePart = new LinePart();
        } else if (shapeDef instanceof RectangleDef) {
            shapePart = new RectanglePart();
        } else if (shapeDef instanceof ShapeFactoryDef) {
            shapePart = new ShapeFactoryPart();
        } else if (shapeDef instanceof SpacerDef) {
            shapePart = new SpacerPart();
        }
        if (shapePart != null) {
            shapePart.init(this, modelElement, shapeDef, Collections.<String, String>emptyMap());
            shapePart.initialize();
            shapePart.setActive(true);
            shapePart.attach((Listener)new FilteredListener<TextChangeEvent>(){

                protected void handleTypedEvent(TextChangeEvent event) {
                    ShapeFactoryPart.this.broadcast(event);
                }
            });
            shapePart.attach((Listener)new FilteredListener<ShapeUpdateEvent>(){

                protected void handleTypedEvent(ShapeUpdateEvent event) {
                    ShapeFactoryPart.this.broadcast(event);
                }
            });
            shapePart.attach((Listener)new FilteredListener<PartVisibilityEvent>(){

                protected void handleTypedEvent(PartVisibilityEvent event) {
                    ShapeFactoryPart.this.broadcast(event);
                }
            });
            shapePart.attach((Listener)new FilteredListener<ShapeAddEvent>(){

                protected void handleTypedEvent(ShapeAddEvent event) {
                    ShapeFactoryPart.this.broadcast(event);
                }
            });
            shapePart.attach((Listener)new FilteredListener<ShapeDeleteEvent>(){

                protected void handleTypedEvent(ShapeDeleteEvent event) {
                    ShapeFactoryPart.this.broadcast(event);
                }
            });
            shapePart.attach((Listener)new FilteredListener<ShapeReorderEvent>(){

                protected void handleTypedEvent(ShapeReorderEvent event) {
                    ShapeFactoryPart.this.broadcast(event);
                }
            });
            shapePart.attach((Listener)new FilteredListener<PartValidationEvent>(){

                protected void handleTypedEvent(PartValidationEvent event) {
                    ShapeFactoryPart.this.refreshValidation();
                }
            });
        }
        return shapePart;
    }

    private ShapePart createShapePart(ShapeFactoryCaseDef shapeFactoryCase, Element modelElement) {
        ShapeDef shapeDef = (ShapeDef)shapeFactoryCase.getShape().content();
        ShapePart shapePart = this.createShapePart(shapeDef, modelElement);
        if (shapeFactoryCase.getSelectionPresentation() != null) {
            shapePart.setSelectionPresentation(shapeFactoryCase.getSelectionPresentation());
        }
        return shapePart;
    }

    private void handleModelPropertyChange(PropertyEvent event) {
        ElementList newList = (ElementList)event.property();
        List<ShapePart> children = this.getChildren();
        ArrayList<Element> oldList = new ArrayList<Element>(children.size());
        for (ShapePart shapePart : children) {
            oldList.add(shapePart.getLocalModelElement());
        }
        List deletedShapes = CollectionsUtil.removedBasedOnEntryIdentity(oldList, (List)newList);
        List newShapes = CollectionsUtil.removedBasedOnEntryIdentity((List)newList, oldList);
        if (deletedShapes.isEmpty() && newShapes.isEmpty()) {
            ArrayList<ShapePart> newChildren = new ArrayList<ShapePart>();
            for (Element listEle : newList) {
                ShapePart shapePart = this.getShapePart(listEle);
                newChildren.add(shapePart);
            }
            this.children.clear();
            this.children.addAll(newChildren);
            this.refreshValidation();
            this.broadcast(new ShapeReorderEvent(this));
        } else {
            for (Element deletedShape : deletedShapes) {
                ShapePart shapePart = this.getShapePart(deletedShape);
                if (shapePart == null) continue;
                shapePart.dispose();
                this.children.remove(shapePart);
                this.refreshValidation();
                this.broadcast(new ShapeDeleteEvent(shapePart));
            }
            for (Element newShape : newShapes) {
                ShapeFactoryCaseDef shapeFactoryCase = this.getShapeFactoryCase(newShape);
                ShapePart shapePart = this.createShapePart(shapeFactoryCase, newShape);
                int newIndex = newList.indexOf((Object)newShape);
                int size = this.children.size();
                int index = newIndex == -1 || newIndex > size ? size : newIndex;
                this.children.add(index, shapePart);
                this.refreshValidation();
                this.broadcast(new ShapeAddEvent(shapePart));
            }
        }
    }
}

