/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.internal;

import java.util.List;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.services.ReferenceService;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionEndpointBindingDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramExplicitConnectionBindingDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.internal.StandardDiagramConnectionPart;

public class StandardEmbeddedConnectionPart
extends StandardDiagramConnectionPart {
    private Element srcNodeModel;
    private Element endpointModel;
    private ModelPath endpointPath;
    private Listener referenceServiceListener;
    private ReferenceValue<?, ?> endpointReferenceValue;
    private IDiagramConnectionEndpointBindingDef endpointDef;

    public StandardEmbeddedConnectionPart(IDiagramExplicitConnectionBindingDef connBindingDef, Element srcNodeModel, ModelPath endpointPath) {
        this.bindingDef = connBindingDef;
        this.srcNodeModel = srcNodeModel;
        this.endpointPath = endpointPath;
    }

    @Override
    protected void init() {
        this.initLabelId();
        this.endpointDef = (IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint2().content();
        this.endpointModel = this.resolveEndpoint(this.modelElement, this.endpointPath);
        this.modelPropertyListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                StandardEmbeddedConnectionPart.this.handleModelPropertyChange(event);
            }
        };
        this.addModelListener();
        this.addReferenceServiceListeners();
    }

    @Override
    public Element getEndpoint1() {
        return this.srcNodeModel;
    }

    @Override
    public Element getEndpoint2() {
        return this.endpointModel;
    }

    @Override
    public void resetEndpoint1(DiagramNodePart newSrcNode) {
    }

    public DiagramNodePart getSourceNodePart() {
        SapphireDiagramEditorPagePart diagramPart = (SapphireDiagramEditorPagePart)this.parent().parent().parent();
        return diagramPart.getDiagramNodePart(this.srcNodeModel);
    }

    @Override
    public String getId() {
        StringBuffer buffer = new StringBuffer(this.getConnectionTypeId());
        buffer.append("&");
        String instanceId = this.getInstanceId();
        if (instanceId != null && instanceId.length() > 0) {
            buffer.append(this.getInstanceId());
            buffer.append("&");
        }
        Element srcNodeElement = this.getSourceNodePart().getLocalModelElement();
        List<StandardDiagramConnectionPart> connParts = this.getDiagramConnectionTemplate().getDiagramConnections(srcNodeElement);
        int index = connParts.indexOf(this);
        buffer.append(index);
        return buffer.toString();
    }

    @Override
    public void addModelListener() {
        this.modelElement.attach(this.modelPropertyListener, (String)this.endpointDef.getProperty().content());
    }

    @Override
    public void addReferenceServiceListeners() {
        this.endpointReferenceValue = this.resolveEndpointReferenceValue(this.modelElement, this.endpointPath);
        if (this.endpointReferenceValue != null) {
            ReferenceService refService = (ReferenceService)this.endpointReferenceValue.service(ReferenceService.class);
            this.referenceServiceListener = new Listener(){

                public void handle(Event event) {
                    StandardEmbeddedConnectionPart.this.handleEndpointReferenceChange();
                }
            };
            if (refService != null) {
                refService.attach(this.referenceServiceListener);
            }
        }
    }

    @Override
    public void removeModelListener() {
        this.modelElement.detach(this.modelPropertyListener, (String)this.endpointDef.getProperty().content());
    }

    @Override
    protected void handleModelPropertyChange(PropertyEvent event) {
        PropertyDef property = event.property().definition();
        if (property.name().equals(this.endpointDef.getProperty().content())) {
            this.endpointModel = this.resolveEndpoint(this.modelElement, this.endpointPath);
            this.notifyConnectionEndpointUpdate();
        }
    }

    protected void handleEndpointReferenceChange() {
        Element newTargetModel = this.resolveEndpoint(this.modelElement, this.endpointPath);
        if (newTargetModel != this.endpointModel) {
            this.endpointModel = newTargetModel;
            this.notifyConnectionEndpointUpdate();
        }
    }
}

