/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import org.eclipse.jface.action.Action;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionSystemPart;
import org.eclipse.sapphire.ui.def.SapphireActionType;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;

public abstract class ActionSystemPartBridge
extends Action {
    private SapphireActionSystemPart sapphireActionSystemPart;
    private Listener listener;

    public ActionSystemPartBridge(SapphireActionSystemPart sapphireActionSystemPart) {
        this.sapphireActionSystemPart = sapphireActionSystemPart;
        this.listener = new Listener(){

            public void handle(Event event) {
                if (event instanceof SapphireActionSystemPart.EnablementChangedEvent) {
                    ActionSystemPartBridge.this.refreshEnablement();
                } else if (event instanceof SapphireActionSystemPart.CheckedStateChangedEvent) {
                    ActionSystemPartBridge.this.refreshCheckedState();
                } else if (event instanceof SapphireActionSystemPart.LabelChangedEvent) {
                    ActionSystemPartBridge.this.refreshText();
                } else if (event instanceof SapphireActionSystemPart.ImagesChangedEvent) {
                    ActionSystemPartBridge.this.refreshImage();
                }
            }
        };
        this.sapphireActionSystemPart.attach(this.listener);
        this.refreshEnablement();
        this.refreshText();
        this.refreshImage();
        if (this.sapphireActionSystemPart instanceof SapphireAction && ((SapphireAction)this.sapphireActionSystemPart).getType() == SapphireActionType.TOGGLE || this.sapphireActionSystemPart instanceof SapphireActionHandler && ((SapphireActionHandler)this.sapphireActionSystemPart).getAction().getType() == SapphireActionType.TOGGLE) {
            this.refreshCheckedState();
        }
    }

    private void refreshEnablement() {
        this.setEnabled(this.sapphireActionSystemPart.isEnabled());
    }

    private void refreshCheckedState() {
        this.setChecked(this.sapphireActionSystemPart.isChecked());
    }

    private void refreshText() {
        this.setText(LabelTransformer.transform((String)this.sapphireActionSystemPart.getLabel(), (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)true));
    }

    private void refreshImage() {
        this.setImageDescriptor(SwtUtil.toImageDescriptor(this.sapphireActionSystemPart.getImage(16)));
    }

    public void dispose() {
        this.sapphireActionSystemPart.detach(this.listener);
    }
}

