/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.forms.swt.SapphireActionPresentation;

public final class SapphireActionPresentationManager {
    @Text(value="actions")
    private static LocalizableText defaultLabel;
    private String label = defaultLabel.text();
    private final Presentation context;
    private final SapphireActionGroup actions;
    private final List<SapphireActionPresentation> presentations;
    private final List<SapphireActionPresentation> presentationsReadOnly;

    static {
        LocalizableText.init(SapphireActionPresentationManager.class);
    }

    public SapphireActionPresentationManager(Presentation context, SapphireActionGroup actions) {
        this.context = context;
        this.actions = actions;
        this.presentations = new ArrayList<SapphireActionPresentation>();
        this.presentationsReadOnly = Collections.unmodifiableList(this.presentations);
    }

    public Presentation context() {
        return this.context;
    }

    public String getLabel() {
        return LabelTransformer.transform((String)this.label, (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)false);
    }

    public void setLabel(String label) {
        this.label = label == null ? defaultLabel.text() : label;
    }

    public List<SapphireActionPresentation> getPresentations() {
        return this.presentationsReadOnly;
    }

    void addPresentation(SapphireActionPresentation presentation) {
        this.presentations.add(presentation);
    }

    public SapphireActionGroup getActionGroup() {
        return this.actions;
    }

    public List<SapphireAction> getActions() {
        return this.actions.getActions();
    }

    public void dispose() {
        for (SapphireActionPresentation presentation : this.presentations) {
            try {
                presentation.dispose();
            }
            catch (Exception e) {
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            }
        }
    }
}

