/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.FormComponentDef;
import org.eclipse.sapphire.ui.forms.swt.SapphireForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;

public class SapphirePropertyPage
extends PropertyPage {
    @Text(value="Error")
    private static LocalizableText errorDialogTitle;
    private Element element;
    private boolean elementInstantiatedLocally;
    private DefinitionLoader.Reference<FormComponentDef> definition;

    static {
        LocalizableText.init(SapphirePropertyPage.class);
    }

    public SapphirePropertyPage(ElementType type, DefinitionLoader.Reference<FormComponentDef> definition) {
        this.init(type, definition);
    }

    public SapphirePropertyPage(Element element, DefinitionLoader.Reference<FormComponentDef> definition) {
        this.init(element, definition);
    }

    protected SapphirePropertyPage() {
    }

    protected void init(ElementType type, DefinitionLoader.Reference<FormComponentDef> definition) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (definition == null) {
            throw new IllegalArgumentException();
        }
        this.elementInstantiatedLocally = true;
        this.init(type.instantiate(), definition);
    }

    protected void init(Element element, DefinitionLoader.Reference<FormComponentDef> definition) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        if (definition == null) {
            throw new IllegalArgumentException();
        }
        this.element = element;
        this.definition = definition;
    }

    public final Element element() {
        return this.element;
    }

    public final FormComponentDef definition() {
        return this.definition.resolve();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getDefaultsButton().setVisible(false);
        parent.layout(true, true);
    }

    protected Control createContents(Composite parent) {
        final SapphireForm form = new SapphireForm(parent, this.element, this.definition);
        final Runnable messageUpdateOperation = new Runnable(){

            @Override
            public void run() {
                Status st = form.part().validation();
                if (st.severity() == Status.Severity.ERROR) {
                    SapphirePropertyPage.this.setMessage(st.message(), 3);
                    SapphirePropertyPage.this.setValid(false);
                } else if (st.severity() == Status.Severity.WARNING) {
                    SapphirePropertyPage.this.setMessage(st.message(), 2);
                    SapphirePropertyPage.this.setValid(true);
                } else {
                    SapphirePropertyPage.this.setMessage(null);
                    SapphirePropertyPage.this.setValid(true);
                }
            }
        };
        messageUpdateOperation.run();
        form.part().attach((Listener)new FilteredListener<PartValidationEvent>(){

            protected void handleTypedEvent(PartValidationEvent event) {
                messageUpdateOperation.run();
            }
        });
        return form;
    }

    public boolean performOk() {
        try {
            this.element.resource().save();
            return true;
        }
        catch (ResourceStoreException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)errorDialogTitle.text(), (String)e.getMessage());
            return false;
        }
    }

    protected void performApply() {
        this.performOk();
    }

    public void dispose() {
        super.dispose();
        if (this.element != null) {
            if (this.elementInstantiatedLocally) {
                this.element.dispose();
            }
            this.element = null;
        }
        if (this.definition != null) {
            this.definition.dispose();
            this.definition = null;
        }
    }
}

