/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import org.eclipse.help.IContext;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.def.ISapphireDocumentation;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationDef;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationRef;
import org.eclipse.sapphire.ui.forms.WizardPagePart;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.HelpSystem;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.sapphire.ui.forms.swt.internal.CompositePresentation;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class SapphireWizardPage
extends WizardPage {
    private final WizardPagePart part;
    private final Listener listener;

    public SapphireWizardPage(WizardPagePart part) {
        super((String)part.definition().getId().content());
        this.part = part;
        this.setTitle(this.part.getLabel());
        this.setDescription(this.part.getDescription());
        this.listener = new Listener(){

            public void handle(Event event) {
                if (event instanceof SapphirePart.ImageChangedEvent) {
                    SapphireWizardPage.this.refreshImage();
                } else if (event instanceof PartValidationEvent) {
                    SapphireWizardPage.this.refreshValidation();
                } else if (event instanceof SapphirePart.LabelChangedEvent) {
                    SapphireWizardPage.this.refreshTitle();
                } else if (event instanceof SapphirePart.DescriptionChangedEvent) {
                    SapphireWizardPage.this.refreshDescription();
                }
            }
        };
        this.part.attach(this.listener);
        this.refreshImage();
        this.refreshValidation();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)GridLayoutUtil.gdfill());
        composite.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 0));
        Composite innerComposite = new Composite(composite, 0);
        innerComposite.setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0));
        innerComposite.setLayoutData((Object)GridLayoutUtil.gdfill());
        CompositePresentation presentation = new CompositePresentation(this.part, null, innerComposite){

            @Override
            public void layout() {
                super.layout();
                IWizardContainer container = SapphireWizardPage.this.getContainer();
                if (container instanceof IWizardContainer2) {
                    ((IWizardContainer2)container).updateSize();
                }
            }
        };
        ((Presentation)presentation).render();
        ISapphireDocumentation doc = (ISapphireDocumentation)this.part.definition().getDocumentation().content();
        if (doc != null) {
            ISapphireDocumentationDef docdef = null;
            docdef = doc instanceof ISapphireDocumentationDef ? (ISapphireDocumentationDef)doc : ((ISapphireDocumentationRef)doc).resolve();
            if (docdef != null) {
                HelpSystem.setHelp((Control)composite, docdef);
            }
        }
        this.setControl((Control)composite);
    }

    public final void performHelp() {
        IContext documentationContext = this.part.getDocumentationContext();
        if (documentationContext != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(documentationContext);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            String initialFocusProperty = (String)this.part.definition().getInitialFocus().content();
            if (initialFocusProperty != null) {
                this.part.setFocus(initialFocusProperty);
            } else {
                this.part.setFocus();
            }
        }
    }

    private final void refreshImage() {
        this.setImageDescriptor(SwtUtil.toImageDescriptor(this.part.getImage()));
    }

    private final void refreshTitle() {
        this.setTitle(this.part.getLabel());
    }

    private final void refreshDescription() {
        this.setDescription(this.part.getDescription());
    }

    private final void refreshValidation() {
        Status st = this.part.validation();
        if (st.severity() == Status.Severity.ERROR) {
            this.setMessage(st.message(), 3);
            this.setPageComplete(false);
        } else if (st.severity() == Status.Severity.WARNING) {
            this.setMessage(st.message(), 2);
            this.setPageComplete(true);
        } else {
            this.setMessage(null);
            this.setPageComplete(true);
        }
    }

    public void dispose() {
        super.dispose();
        this.part.detach(this.listener);
    }
}

