/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.services.ValueLabelService;
import org.eclipse.sapphire.services.ValueNormalizationService;

public final class PossibleValue {
    private final String value;
    private final String label;

    public static Factory factory(Property property) {
        return new Factory(property);
    }

    private PossibleValue(String value, String label) {
        this.value = value;
        this.label = label;
    }

    public String value() {
        return this.value;
    }

    public String label() {
        return this.label;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PossibleValue) {
            return this.value.equals(((PossibleValue)obj).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    /* synthetic */ PossibleValue(String string, String string2, PossibleValue possibleValue) {
        this(string, string2);
    }

    public static final class Factory {
        private final PossibleValuesService possibleValuesService;
        private final ValueNormalizationService valueNormalizationService;
        private final ValueLabelService valueLabelService;

        private Factory(Property property) {
            this.possibleValuesService = (PossibleValuesService)property.service(PossibleValuesService.class);
            this.valueNormalizationService = (ValueNormalizationService)property.service(ValueNormalizationService.class);
            this.valueLabelService = (ValueLabelService)property.service(ValueLabelService.class);
        }

        public List<PossibleValue> entries() {
            ArrayList<PossibleValue> entries = new ArrayList<PossibleValue>();
            for (String value : this.possibleValuesService.values()) {
                entries.add(this.entry(value));
            }
            return Collections.unmodifiableList(entries);
        }

        public PossibleValue entry(String value) {
            String normalized = this.valueNormalizationService.normalize(value);
            String label = this.valueLabelService.provide(normalized);
            return new PossibleValue(normalized, label, null);
        }
    }
}

