/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementImpl;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.util.IdentityHashSet;
import org.eclipse.sapphire.util.SetFactory;

public final class Index<T extends Element> {
    @Text(value="{0} property is already disposed.")
    private static LocalizableText propertyAlreadyDisposed;
    private final ElementList<T> list;
    private final ValueProperty property;
    private Map<String, Object> keyToElements;
    private Map<Element, String> elementToKey;
    private Listener listener;
    private ListenerContext listeners;

    static {
        LocalizableText.init(Index.class);
    }

    Index(ElementList<T> list, ValueProperty property) {
        this.list = list;
        this.property = property;
    }

    private void initialize() {
        if (this.keyToElements == null) {
            this.listener = new FilteredListener<PropertyContentEvent>(){

                @Override
                protected void handleTypedEvent(PropertyContentEvent event) {
                    Index.this.handle(event);
                }
            };
            this.list.attach(this.listener);
            this.keyToElements = new HashMap<String, Object>();
            this.elementToKey = new IdentityHashMap<Element, String>();
            for (Element element : this.list) {
                this.insert(element);
                element.attach(this.listener);
                element.property(this.property).attach(this.listener);
            }
        }
    }

    public ElementList<?> list() {
        return this.list;
    }

    public ValueProperty property() {
        return this.property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T element(String key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.list.root();
        synchronized (element) {
            this.assertNotDisposed();
            this.initialize();
            Object obj = this.keyToElements.get(key);
            if (obj != null) {
                if (obj instanceof Element) {
                    return (T)((Element)obj);
                }
                return (T)((Element)((Set)obj).iterator().next());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<T> elements(String key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.list.root();
        synchronized (element) {
            this.assertNotDisposed();
            this.initialize();
            Object obj = this.keyToElements.get(key);
            if (obj != null) {
                if (obj instanceof Element) {
                    return SetFactory.singleton((Element)obj);
                }
                return Collections.unmodifiableSet(new IdentityHashSet((Set)obj));
            }
        }
        return SetFactory.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.list.root();
        synchronized (element) {
            this.assertNotDisposed();
            if (this.listeners == null) {
                this.listeners = new ListenerContext();
                this.listeners.coordinate(((ElementImpl)this.list.element()).listeners());
            }
            this.listeners.attach(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.list.root();
        synchronized (element) {
            if (this.listeners != null) {
                this.listeners.detach(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(PropertyContentEvent event) {
        Element element = this.list.root();
        synchronized (element) {
            boolean changed = false;
            Property property = event.property();
            if (property instanceof Value) {
                Element element2 = property.element();
                this.remove(element2);
                this.insert(element2);
                changed = true;
            } else {
                for (Element element3 : this.list) {
                    if (this.elementToKey.containsKey(element3)) continue;
                    this.insert(element3);
                    element3.attach(this.listener);
                    element3.property(this.property).attach(this.listener);
                    changed = true;
                }
                ArrayList<Element> disposed = null;
                for (Element element4 : this.elementToKey.keySet()) {
                    if (!element4.disposed()) continue;
                    if (disposed == null) {
                        disposed = new ArrayList<Element>(1);
                    }
                    disposed.add(element4);
                }
                if (disposed != null) {
                    for (Element element4 : disposed) {
                        this.remove(element4);
                    }
                    changed = true;
                }
            }
            if (changed && this.listeners != null) {
                this.listeners.broadcast(new Event());
            }
        }
    }

    private void insert(Element element) {
        if (element == null) {
            throw new IllegalStateException();
        }
        String key = element.property(this.property).text();
        if (key != null) {
            Object object = this.keyToElements.get(key);
            if (object == null) {
                this.keyToElements.put(key, element);
            } else if (object instanceof Element) {
                IdentityHashSet set = new IdentityHashSet();
                set.add((Element)object);
                set.add(element);
                this.keyToElements.put(key, set);
            } else {
                Set set = (Set)object;
                set.add(element);
            }
            this.elementToKey.put(element, key);
        }
    }

    private void remove(Element element) {
        Object object;
        if (element == null) {
            throw new IllegalStateException();
        }
        String key = this.elementToKey.remove(element);
        if (key != null && (object = this.keyToElements.get(key)) != null) {
            if (object instanceof Element) {
                this.keyToElements.remove(key);
            } else {
                Set set = (Set)object;
                set.remove(element);
                if (set.size() == 1) {
                    this.keyToElements.put(key, set.iterator().next());
                }
            }
        }
    }

    private void assertNotDisposed() {
        if (this.list.disposed()) {
            String msg = propertyAlreadyDisposed.format(this.list.name());
            throw new IllegalStateException(msg);
        }
    }
}

