/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.address.internal;

import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.samples.address.Address;
import org.eclipse.sapphire.samples.zipcodes.ZipCodeRepository;
import org.eclipse.sapphire.services.PossibleValuesService;

public final class ZipCodePossibleValuesService
extends PossibleValuesService {
    protected void init() {
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                ZipCodePossibleValuesService.this.broadcast();
            }
        };
        Address address = (Address)this.context(Address.class);
        address.getCity().attach((Listener)listener);
        address.getState().attach((Listener)listener);
    }

    protected void fillPossibleValues(Set<String> values) {
        Address address = (Address)this.context(Address.class);
        String city = address.getCity().text();
        String state = address.getState().text();
        values.addAll(ZipCodeRepository.getZipCodes(state, city));
    }

    public String getInvalidValueMessage(String invalidValue) {
        return MessageFormat.format("\"{0}\" is not a valid ZIP code for the specified city and state.", invalidValue);
    }
}

