/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.catalog;

import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ListPropertyBinding;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.modeling.xml.ChildXmlResource;
import org.eclipse.sapphire.modeling.xml.StandardXmlListBindingImpl;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlUtil;
import org.eclipse.sapphire.samples.catalog.Catalog;
import org.eclipse.sapphire.samples.catalog.Category;
import org.eclipse.sapphire.samples.catalog.Item;
import org.eclipse.sapphire.samples.catalog.MultiVariantItem;
import org.eclipse.sapphire.samples.catalog.SingleVariantItem;
import org.eclipse.sapphire.util.IdentityHashSet;
import org.eclipse.sapphire.util.ListFactory;

public final class CategoriesBinding
extends ListPropertyBinding {
    private List<CategoryResource> cache = ListFactory.empty();
    private Listener listener;

    public void init(final Property property) {
        super.init(property);
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                property.refresh();
                for (Category category : ((Catalog)property.element()).getCategories()) {
                    category.getItems().refresh();
                }
            }
        };
        property.element().attach(this.listener, "Items/Category");
    }

    public List<? extends Resource> read() {
        List resources;
        TreeSet<String> categories = new TreeSet<String>(CategoryNamesComparator.INSTANCE);
        for (Item item : ((Catalog)this.property().element()).getItems()) {
            categories.add(item.getCategory().text());
        }
        ListFactory resourcesListFactory = ListFactory.start();
        IdentityHashSet reused = new IdentityHashSet();
        for (String category : categories) {
            boolean found = false;
            for (CategoryResource resource : this.cache) {
                if (CategoryNamesComparator.INSTANCE.compare(category, resource.getName()) != 0) continue;
                resourcesListFactory.add((Object)resource);
                reused.add(resource);
                found = true;
                break;
            }
            if (found) continue;
            resourcesListFactory.add((Object)new CategoryResource(category));
        }
        for (CategoryResource resource : this.cache) {
            if (reused.contains((Object)resource)) continue;
            resource.dispose();
        }
        this.cache = resources = resourcesListFactory.result();
        this.cache = resources;
        return this.cache;
    }

    public ElementType type(Resource resource) {
        return Category.TYPE;
    }

    public void dispose() {
        for (CategoryResource resource : this.cache) {
            resource.dispose();
        }
        this.cache = null;
        this.property().element().detach(this.listener, "Items/Category");
        this.listener = null;
    }

    private static final class CategoryNamesComparator
    implements Comparator<String> {
        public static CategoryNamesComparator INSTANCE = new CategoryNamesComparator();

        private CategoryNamesComparator() {
        }

        @Override
        public int compare(String x, String y) {
            x = x == null ? "" : x.trim();
            String string = y = y == null ? "" : y.trim();
            if (x.length() == 0) {
                return Integer.MAX_VALUE;
            }
            if (y.length() == 0) {
                return -2147483647;
            }
            return x.compareToIgnoreCase(y);
        }
    }

    private final class CategoryResource
    extends Resource {
        private String name;

        public CategoryResource(String name) {
            super(CategoriesBinding.this.property().element().resource());
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            for (Item item : ((Category)this.element()).getItems()) {
                item.setCategory(name);
            }
        }

        protected PropertyBinding createBinding(Property property) {
            PropertyDef pdef = property.definition();
            Object binding = null;
            if (pdef == Category.PROP_NAME) {
                binding = new ValuePropertyBinding(){

                    public String read() {
                        return CategoryResource.this.getName();
                    }

                    public void write(String value) {
                        CategoryResource.this.setName(value);
                    }
                };
            } else if (pdef == Category.PROP_ITEMS) {
                binding = new StandardXmlListBindingImpl(){

                    protected void initBindingMetadata() {
                        this.xmlElementNames = new QName[]{XmlUtil.createQualifiedName((String)"Item", null), XmlUtil.createQualifiedName((String)"MultiVariantItem", null)};
                        this.modelElementTypes = new ElementType[]{SingleVariantItem.TYPE, MultiVariantItem.TYPE};
                    }

                    protected List<?> readUnderlyingList() {
                        List all = super.readUnderlyingList();
                        ListFactory filtered = ListFactory.start();
                        for (Object obj : all) {
                            XmlElement element = (XmlElement)obj;
                            String category = element.getChildNodeText("Category");
                            if (CategoryNamesComparator.INSTANCE.compare(CategoryResource.this.name, category) != 0) continue;
                            filtered.add((Object)element);
                        }
                        return filtered.result();
                    }

                    protected Object insertUnderlyingObject(ElementType type, int position) {
                        XmlElement element = (XmlElement)super.insertUnderlyingObject(type, position);
                        element.setChildNodeText("Category", CategoryResource.this.name, true);
                        return element;
                    }

                    protected Resource resource(Object obj) {
                        return new ChildXmlResource((Resource)CategoryResource.this, (XmlElement)obj);
                    }

                    protected XmlElement getXmlElement(boolean createIfNecessary) {
                        return ((XmlResource)((Catalog)CategoryResource.this.element().nearest(Catalog.class)).adapt(XmlResource.class)).getXmlElement(createIfNecessary);
                    }
                };
            }
            return binding;
        }
    }
}

