/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.catalog;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.samples.catalog.Item;
import org.eclipse.sapphire.ui.PartFunctionContext;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.forms.MasterDetailsEditorPagePart;
import org.eclipse.sapphire.ui.forms.MasterDetailsEditorPageState;

public final class ItemImageFunction
extends Function {
    private final ImageData IMAGE_GENERIC = (ImageData)ImageData.readFromClassLoader(ItemImageFunction.class, (String)"Item.png").required();
    private final ImageData[] IMAGES = new ImageData[]{(ImageData)ImageData.readFromClassLoader(ItemImageFunction.class, (String)"ItemBlue.png").required(), (ImageData)ImageData.readFromClassLoader(ItemImageFunction.class, (String)"ItemGreen.png").required(), (ImageData)ImageData.readFromClassLoader(ItemImageFunction.class, (String)"ItemOrange.png").required(), (ImageData)ImageData.readFromClassLoader(ItemImageFunction.class, (String)"ItemPurple.png").required(), (ImageData)ImageData.readFromClassLoader(ItemImageFunction.class, (String)"ItemRed.png").required(), (ImageData)ImageData.readFromClassLoader(ItemImageFunction.class, (String)"ItemTurquoise.png").required(), (ImageData)ImageData.readFromClassLoader(ItemImageFunction.class, (String)"ItemYellow.png").required()};

    public String name() {
        return "CatalogItemImage";
    }

    public FunctionResult evaluate(FunctionContext context) {
        Element element;
        SapphirePart part;
        MasterDetailsEditorPagePart page;
        if (context instanceof PartFunctionContext && (page = (MasterDetailsEditorPagePart)(part = ((PartFunctionContext)context).part()).nearest(MasterDetailsEditorPagePart.class)) != null && (element = part.getLocalModelElement()) instanceof Item) {
            final Item item = (Item)element;
            final MasterDetailsEditorPageState state = page.state();
            return new FunctionResult(this, context){
                private Listener listener;

                protected void init() {
                    this.listener = new FilteredListener<PropertyContentEvent>(){

                        protected void handleTypedEvent(PropertyContentEvent event) {
                            this.refresh();
                        }
                    };
                    state.attach(this.listener, String.valueOf(MasterDetailsEditorPageState.PROP_ATTRIBUTES.name()) + "/*");
                    element.property(Item.PROP_MANUFACTURER).attach(this.listener);
                }

                protected Object evaluate() {
                    boolean color = (Boolean)state.getAttribute("ColorCode", (Object)false);
                    if (color) {
                        String manufacturer = (String)item.getManufacturer().content();
                        int hashCode = manufacturer == null ? 0 : manufacturer.hashCode();
                        int index = Math.abs(hashCode) % ItemImageFunction.this.IMAGES.length;
                        return ItemImageFunction.this.IMAGES[index];
                    }
                    return ItemImageFunction.this.IMAGE_GENERIC;
                }

                public void dispose() {
                    super.dispose();
                    if (this.listener != null) {
                        state.detach(this.listener, String.valueOf(MasterDetailsEditorPageState.PROP_ATTRIBUTES.name()) + "/*");
                        element.property(Item.PROP_MANUFACTURER).detach(this.listener);
                        this.listener = null;
                    }
                }
            };
        }
        throw new FunctionException("CatalogItemImage() function cannot be used in this context.");
    }
}

