/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.xml.xsd.t0006;

import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.modeling.xml.XmlUtil;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.util.StringUtil;
import org.junit.Test;
import org.w3c.dom.Document;

public final class TestXmlXsd0006
extends SapphireTestCase {
    @Test
    public void testConvertToNamespaceForm1() throws Exception {
        this.testConvertToNamespaceForm("ConvertToNamespaceForm-1-Initial.txt", "ConvertToNamespaceForm-1-Expected.txt", "http://www.eclipse.org/sapphire/tests/xml/xsd/0006");
    }

    @Test
    public void testConvertToNamespaceForm2() throws Exception {
        this.testConvertToNamespaceForm("ConvertToNamespaceForm-2-Initial.txt", "ConvertToNamespaceForm-2-Expected.txt", "http://www.eclipse.org/sapphire/tests/xml/xsd/0006", null);
    }

    @Test
    public void testConvertToNamespaceForm3() throws Exception {
        this.testConvertToNamespaceForm("ConvertToNamespaceForm-3-Initial.txt", "ConvertToNamespaceForm-3-Expected.txt", "http://www.eclipse.org/sapphire/tests/xml/xsd/0006", "http://www.eclipse.org/sapphire/tests/xml/xsd/0006");
    }

    @Test
    public void testConvertToNamespaceForm4() throws Exception {
        this.testConvertToNamespaceForm("ConvertToNamespaceForm-4-Initial.txt", "ConvertToNamespaceForm-4-Expected.txt", "http://www.eclipse.org/sapphire/tests/xml/xsd/0006", "http://www.eclipse.org/sapphire/tests/xml/xsd/0006/v1");
    }

    private void testConvertToNamespaceForm(String initialResourceName, String expectedResourceName, final String namespace) throws Exception {
        this.test(initialResourceName, expectedResourceName, new ConvertOp(){

            @Override
            public void run(Document document) {
                XmlUtil.convertToNamespaceForm((Document)document, (String)namespace);
            }
        });
    }

    private void testConvertToNamespaceForm(String initialResourceName, String expectedResourceName, final String namespace, final String schemaLocation) throws Exception {
        this.test(initialResourceName, expectedResourceName, new ConvertOp(){

            @Override
            public void run(Document document) {
                XmlUtil.convertToNamespaceForm((Document)document, (String)namespace, (String)schemaLocation);
            }
        });
    }

    @Test
    public void testConvertFromNamespaceForm1() throws Exception {
        this.testConvertFromNamespaceForm("ConvertFromNamespaceForm-1-Initial.txt", "ConvertFromNamespaceForm-1-Expected.txt");
    }

    @Test
    public void testConvertFromNamespaceForm2() throws Exception {
        this.testConvertFromNamespaceForm("ConvertFromNamespaceForm-2-Initial.txt", "ConvertFromNamespaceForm-2-Expected.txt");
    }

    private void testConvertFromNamespaceForm(String initialResourceName, String expectedResourceName) throws Exception {
        this.test(initialResourceName, expectedResourceName, new ConvertOp(){

            @Override
            public void run(Document document) {
                XmlUtil.convertFromNamespaceForm((Document)document);
            }
        });
    }

    private void test(String initialResourceName, String expectedResourceName, ConvertOp op) throws Exception {
        String initial = this.loadResource(initialResourceName);
        String expected = this.loadResource(expectedResourceName);
        ByteArrayResourceStore byteArrayResourceStore = new ByteArrayResourceStore(initial);
        XmlResourceStore xmlResourceStore = new XmlResourceStore(byteArrayResourceStore);
        op.run(xmlResourceStore.getDomDocument());
        xmlResourceStore.save();
        String actual = new String(byteArrayResourceStore.getContents(), StringUtil.UTF8);
        TestXmlXsd0006.assertEqualsIgnoreNewLineDiffs(expected, actual);
    }

    private static abstract class ConvertOp {
        private ConvertOp() {
        }

        public abstract void run(Document var1);
    }
}

