/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.unique;

import org.eclipse.sapphire.Counter;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.internal.UniqueValueValidationService;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.unique.TestElement;
import org.junit.Ignore;
import org.junit.Test;

public final class UniqueValueTests
extends SapphireTestCase {
    @Test
    public void testUniqueValue() throws Exception {
        ByteArrayResourceStore byteArrayResourceStore = new ByteArrayResourceStore(this.generateTestData(10));
        XmlResourceStore xmlResourceStore = new XmlResourceStore(byteArrayResourceStore);
        TestElement element = (TestElement)TestElement.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
        UniqueValueTests.assertValidationOk(element);
        ((TestElement.ListEntry)element.getList().get(0)).setValue("9");
        UniqueValueTests.assertValidationError(element.getList().get(0), "Unique value required. Another occurrence of \"9\" was found");
        UniqueValueTests.assertValidationError(element.getList().get(9), "Unique value required. Another occurrence of \"9\" was found");
        UniqueValueTests.assertValidationOk(element.getList().get(1));
        ((TestElement.ListEntry)element.getList().get(0)).setValue("0");
        UniqueValueTests.assertValidationOk(element);
    }

    @Test
    public void testUniqueValuePerformance10() throws Exception {
        this.testUniqueValuePerformance(10);
    }

    @Test
    public void testUniqueValuePerformance100() throws Exception {
        this.testUniqueValuePerformance(100);
    }

    @Test
    public void testUniqueValuePerformance1000() throws Exception {
        this.testUniqueValuePerformance(1000);
    }

    @Test
    public void testUniqueValuePerformance10000() throws Exception {
        this.testUniqueValuePerformance(10000);
    }

    @Test
    @Ignore
    public void testUniqueValuePerformance100000() throws Exception {
        this.testUniqueValuePerformance(100000);
    }

    private void testUniqueValuePerformance(int entries) throws Exception {
        Counter counter = Counter.find(UniqueValueValidationService.class);
        ByteArrayResourceStore byteArrayResourceStore = new ByteArrayResourceStore(this.generateTestData(entries));
        XmlResourceStore xmlResourceStore = new XmlResourceStore(byteArrayResourceStore);
        counter.reset();
        TestElement element = (TestElement)TestElement.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
        element.validation();
        UniqueValueTests.assertEquals((long)entries, (long)counter.read());
        counter.reset();
        ((TestElement.ListEntry)element.getList().get(0)).setValue("a");
        element.validation();
        UniqueValueTests.assertEquals((long)(entries + 1), (long)counter.read());
        counter.reset();
        ((TestElement.ListEntry)element.getList().get(0)).setValue("9");
        element.validation();
        UniqueValueTests.assertEquals((long)(entries + 1), (long)counter.read());
    }

    private String generateTestData(int entries) {
        StringBuilder content = new StringBuilder();
        content.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        content.append("<root>");
        int i = 0;
        while (i < entries) {
            content.append("<entry>");
            content.append(i);
            content.append("</entry>");
            ++i;
        }
        content.append("</root>");
        return content.toString();
    }
}

