/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Ray;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sapphire.ui.Bounds;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramConnectionModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramNodeModel;
import org.eclipse.sapphire.ui.swt.gef.utils.MultiValueMap;

public class SapphireConnectionRouter {
    private MultiValueMap connections = new MultiValueMap();
    private MultiValueMap connectionIndices = new MultiValueMap();
    private HashMap<DiagramConnectionModel, Integer> connectionIndexMap = new HashMap();
    private int separation = 30;

    public int getSeparation() {
        return this.separation;
    }

    public void setSeparation(int value) {
        this.separation = value;
    }

    public void removeConnectionFromCache(DiagramConnectionModel conn) {
        HashKey connectionKey = new HashKey(conn);
        this.connections.remove(connectionKey, conn);
        if (this.connectionIndexMap.containsKey(conn)) {
            int index = this.connectionIndexMap.get(conn);
            this.connectionIndices.remove(connectionKey, index);
        }
    }

    public void clear() {
        this.connectionIndexMap.clear();
        this.connections.clear();
        this.connectionIndices.clear();
    }

    private Point getNodeLocation(DiagramNodeModel node) {
        Bounds bounds = node.getNodeBounds();
        if (node.getShapePresentation().getFigure() != null) {
            Rectangle rect = node.getShapePresentation().getFigure().getBounds();
            int x = rect.x != -1 ? rect.x : bounds.getX();
            int y = rect.y != -1 ? rect.y : bounds.getY();
            return new Point(x + rect.width / 2, y + rect.height / 2);
        }
        return new Point(bounds.getX() + bounds.getWidth() / 2, bounds.getY() + bounds.getWidth() / 2);
    }

    public Point route(DiagramConnectionModel conn) {
        HashKey connectionKey = new HashKey(conn);
        ArrayList connectionList = this.connections.get(connectionKey);
        if (connectionList != null) {
            PointList points = new PointList();
            points.addPoint(this.getNodeLocation(conn.getSourceNode()));
            points.addPoint(this.getNodeLocation(conn.getTargetNode()));
            int index = this.getNextConnectionIndex(connectionKey);
            this.addConnectionKey(conn, connectionKey, index);
            Point bendpoint = this.handleCollision(points, index);
            return bendpoint;
        }
        this.addConnectionKey(conn, connectionKey, -1);
        return null;
    }

    public void addConnection(DiagramConnectionModel conn) {
        HashKey connectionKey = new HashKey(conn);
        this.addConnectionKey(conn, connectionKey, -1);
    }

    private void addConnectionKey(DiagramConnectionModel conn, HashKey connectionKey, int index) {
        this.connections.put(connectionKey, conn);
        this.connectionIndices.put(connectionKey, index);
        this.connectionIndexMap.put(conn, index);
    }

    private Point handleCollision(PointList points, int index) {
        Point end;
        Point start = points.getFirstPoint();
        if (start.equals((Object)(end = points.getLastPoint()))) {
            return null;
        }
        Point midPoint = new Point((end.x + start.x) / 2, (end.y + start.y) / 2);
        int position = end.getPosition(start);
        Ray ray = position == 4 || position == 16 ? new Ray(start, end) : new Ray(end, start);
        double length = ray.length();
        double xSeparation = (double)(this.getSeparation() * ray.x) / length;
        double ySeparation = (double)(this.getSeparation() * ray.y) / length;
        Point bendPoint = index % 2 == 0 ? new Point((double)midPoint.x + (double)index / 2.0 * (-1.0 * ySeparation), (double)midPoint.y + (double)index / 2.0 * xSeparation) : new Point((double)midPoint.x + (double)index / 2.0 * ySeparation, (double)midPoint.y + (double)index / 2.0 * (-1.0 * xSeparation));
        if (!bendPoint.equals((Object)midPoint)) {
            return bendPoint;
        }
        return null;
    }

    private int getNextConnectionIndex(HashKey connectionKey) {
        ArrayList indices = this.connectionIndices.get(connectionKey);
        int[] intArr = new int[indices.size()];
        int i = 0;
        for (Object obj : indices) {
            Integer intObj = (Integer)obj;
            intArr[i++] = intObj;
        }
        Arrays.sort(intArr, 0, indices.size());
        int nextInt = -1;
        int j = 0;
        while (j < intArr.length) {
            int temp = intArr[j];
            if (temp > 1 && temp != j + 1) {
                nextInt = j + 1;
                break;
            }
            ++j;
        }
        if (nextInt == -1) {
            nextInt = indices.size() + 1;
        }
        return nextInt;
    }

    private static final class HashKey {
        private DiagramNodeModel sourceNode;
        private DiagramNodeModel targetNode;

        HashKey(DiagramConnectionModel conn) {
            this.sourceNode = conn.getSourceNode();
            this.targetNode = conn.getTargetNode();
        }

        public boolean equals(Object object) {
            boolean isEqual = false;
            if (object instanceof HashKey) {
                HashKey hashKey = (HashKey)object;
                DiagramNodeModel hkA1 = hashKey.getFirstNode();
                DiagramNodeModel hkA2 = hashKey.getSecondNode();
                isEqual = hkA1.equals(this.sourceNode) && hkA2.equals(this.targetNode) || hkA1.equals(this.targetNode) && hkA2.equals(this.sourceNode);
            }
            return isEqual;
        }

        public DiagramNodeModel getFirstNode() {
            return this.sourceNode;
        }

        public DiagramNodeModel getSecondNode() {
            return this.targetNode;
        }

        public int hashCode() {
            return this.sourceNode.hashCode() ^ this.targetNode.hashCode();
        }
    }
}

