/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.layout;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sapphire.ui.def.HorizontalAlignment;
import org.eclipse.sapphire.ui.def.MarginPresentation;
import org.eclipse.sapphire.ui.def.VerticalAlignment;
import org.eclipse.sapphire.ui.diagram.shape.def.SequenceLayoutDef;
import org.eclipse.sapphire.ui.swt.gef.layout.LayoutUtil;
import org.eclipse.sapphire.ui.swt.gef.layout.SapphireStackLayoutConstraint;

public class SapphireStackLayout
extends AbstractLayout {
    private Map<IFigure, Object> constraints = new HashMap<IFigure, Object>();
    private Insets marginInsets;

    public SapphireStackLayout(SequenceLayoutDef def) {
        this.marginInsets = LayoutUtil.calculateMargin((MarginPresentation)def);
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Insets insets = container.getInsets();
        Dimension size = this.getStackedChildrenSize(container.getChildren());
        size.width += this.marginInsets.left + this.marginInsets.right;
        size.height += this.marginInsets.top + this.marginInsets.bottom;
        return size.expand(insets.getWidth(), insets.getHeight()).union(this.getBorderPreferredSize(container));
    }

    public Dimension calculateMaximumSize(IFigure container) {
        return this.calculatePreferredSize(container, -1, -1);
    }

    public Point getOrigin(IFigure parent) {
        return parent.getClientArea().getLocation();
    }

    public void layout(IFigure parent) {
        List children = parent.getChildren();
        if (children.size() == 0) {
            return;
        }
        Dimension baseSize = this.getStackedChildrenSize(children);
        Point offset = this.getOrigin(parent);
        offset.x += this.marginInsets.left;
        offset.y += this.marginInsets.top;
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Dimension childSize = child.getPreferredSize();
            SapphireStackLayoutConstraint constraint = (SapphireStackLayoutConstraint)this.getConstraint(child);
            Point childOffset = this.getOffset(baseSize, childSize, constraint);
            Rectangle childBounds = new Rectangle(childOffset.x, childOffset.y, childSize.width, childSize.height);
            childBounds = childBounds.getTranslated(offset);
            child.setBounds(childBounds);
            ++i;
        }
    }

    public Object getConstraint(IFigure figure) {
        return this.constraints.get(figure);
    }

    public void remove(IFigure figure) {
        super.remove(figure);
        this.constraints.remove(figure);
    }

    public void setConstraint(IFigure figure, Object newConstraint) {
        super.setConstraint(figure, newConstraint);
        if (newConstraint != null) {
            this.constraints.put(figure, newConstraint);
        }
    }

    private Point getOffset(Dimension baseSize, Dimension childSize, SapphireStackLayoutConstraint constraint) {
        int offsetX = 0;
        int offsetY = 0;
        HorizontalAlignment horizontalAlign = constraint.getHorizontalAlignment();
        if (horizontalAlign == HorizontalAlignment.LEFT) {
            offsetX = constraint.getLeftMargin();
        } else if (horizontalAlign == HorizontalAlignment.RIGHT) {
            offsetX = baseSize.width - constraint.getRightMargin() - childSize.width;
        } else if (horizontalAlign == HorizontalAlignment.CENTER) {
            offsetX = baseSize.width - childSize.width + 1 >> 1;
        }
        VerticalAlignment verticalAlign = constraint.getVerticalAlignment();
        if (verticalAlign == VerticalAlignment.TOP) {
            offsetY = constraint.getTopMargin();
        } else if (verticalAlign == VerticalAlignment.BOTTOM) {
            offsetY = baseSize.height - constraint.getBottomMargin() - childSize.height;
        } else if (verticalAlign == VerticalAlignment.CENTER) {
            offsetY = baseSize.height - childSize.height + 1 >> 1;
        }
        return new Point(offsetX, offsetY);
    }

    private Dimension getStackedChildrenSize(List children) {
        Dimension size = new Dimension(0, 0);
        for (Object child : children) {
            IFigure childFigure = (IFigure)child;
            Dimension childSize = childFigure.getPreferredSize();
            size.width = Math.max(size.width, childSize.width);
            size.height = Math.max(size.height, childSize.height);
        }
        return size;
    }
}

