/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.sapphire.Color;
import org.eclipse.sapphire.ui.LineStyle;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.shape.def.FontDef;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class DiagramResourceCache {
    private List<org.eclipse.swt.graphics.Color> colors = new ArrayList<org.eclipse.swt.graphics.Color>();
    private List<Font> fonts = new ArrayList<Font>();
    private static final Color OUTLINE_FOREGROUND = new Color(255, 165, 0);

    public DiagramResourceCache() {
        FontDescriptor descriptor = JFaceResources.getDefaultFontDescriptor();
        FontData[] fontData = descriptor.getFontData();
        FontData smallerFontData = new FontData(fontData[0].getName(), fontData[0].getHeight() - 1, 0);
        Font defaultFont = new Font(null, new FontData[]{smallerFontData});
        this.fonts.add(defaultFont);
    }

    public int getLinkStyle(IDiagramConnectionDef def) {
        int linkStyle = 1;
        if (def != null) {
            LineStyle style = (LineStyle)def.getLineStyle().content();
            if (style == LineStyle.DASH) {
                linkStyle = 2;
            } else if (style == LineStyle.DOT) {
                linkStyle = 3;
            } else if (style == LineStyle.DASH_DOT) {
                linkStyle = 4;
            }
        }
        return linkStyle;
    }

    public org.eclipse.swt.graphics.Color getLineColor(DiagramConnectionPart connection) {
        IDiagramConnectionDef def = connection.getConnectionDef();
        org.eclipse.swt.graphics.Color color = ColorConstants.darkBlue;
        if (def != null) {
            return this.getColor((Color)def.getLineColor().content());
        }
        return color;
    }

    public org.eclipse.swt.graphics.Color getColor(Color sapphireColor) {
        int red = sapphireColor.red();
        int green = sapphireColor.green();
        int blue = sapphireColor.blue();
        for (org.eclipse.swt.graphics.Color existingColor : this.colors) {
            if (existingColor.getRed() != red || existingColor.getGreen() != green || existingColor.getBlue() != blue) continue;
            return existingColor;
        }
        org.eclipse.swt.graphics.Color newColor = new org.eclipse.swt.graphics.Color((Device)Display.getCurrent(), red, green, blue);
        this.colors.add(newColor);
        return newColor;
    }

    public org.eclipse.swt.graphics.Color getOutlineColor() {
        return this.getColor(OUTLINE_FOREGROUND);
    }

    public Font getDefaultFont() {
        return this.fonts.get(0);
    }

    public Font getFont(FontDef fontDef) {
        if (fontDef == null) {
            throw new IllegalArgumentException();
        }
        String name = (String)fontDef.getName().content();
        if (name.equalsIgnoreCase("System")) {
            name = this.getDefaultFont().getFontData()[0].getName();
        }
        int size = (Integer)fontDef.getSize().content();
        int style = 0;
        if (((Boolean)fontDef.isBold().content()).booleanValue()) {
            style |= 1;
        }
        if (((Boolean)fontDef.isItalic().content()).booleanValue()) {
            style |= 2;
        }
        for (Font existingFont : this.fonts) {
            FontData data = existingFont.getFontData()[0];
            if (!data.getName().equals(name) || data.getHeight() != size || data.getStyle() != style) continue;
            return existingFont;
        }
        FontData newFontData = new FontData(name, size, style);
        Font newFont = new Font((Device)Display.getCurrent(), newFontData);
        this.fonts.add(newFont);
        return newFont;
    }

    public void dispose() {
        for (org.eclipse.swt.graphics.Color existingColor : this.colors) {
            existingColor.dispose();
        }
        for (Font existingFont : this.fonts) {
            existingFont.dispose();
        }
    }
}

