/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.po;

import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ExecutableElement;
import org.eclipse.sapphire.PossibleValues;
import org.eclipse.sapphire.Transient;
import org.eclipse.sapphire.TransientProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.DelegateImplementation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Listeners;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.samples.po.PurchaseComputerOpListener;
import org.eclipse.sapphire.samples.po.PurchaseComputerOpMethods;
import org.eclipse.sapphire.samples.po.PurchaseOrder;

public interface PurchaseComputerOp
extends ExecutableElement {
    public static final ElementType TYPE = new ElementType(PurchaseComputerOp.class);
    @Type(base=PurchaseOrder.class)
    public static final TransientProperty PROP_PURCHASE_ORDER = new TransientProperty(TYPE, "PurchaseOrder");
    @Type(base=Importance.class)
    @Label(standard="performance")
    @DefaultValue(text="2")
    @Listeners(value={PurchaseComputerOpListener.class})
    public static final ValueProperty PROP_PERFORMANCE_IMPORTANCE = new ValueProperty(TYPE, "PerformanceImportance");
    @Type(base=Importance.class)
    @Label(standard="storage")
    @DefaultValue(text="2")
    @Listeners(value={PurchaseComputerOpListener.class})
    public static final ValueProperty PROP_STORAGE_IMPORTANCE = new ValueProperty(TYPE, "StorageImportance");
    @Type(base=Importance.class)
    @Label(standard="gaming")
    @DefaultValue(text="1")
    @Listeners(value={PurchaseComputerOpListener.class})
    public static final ValueProperty PROP_GAMING_IMPORTANCE = new ValueProperty(TYPE, "GamingImportance");
    @Label(standard="processor")
    @PossibleValues(values={"Intel Core i7 4960X - 3.6 GHz - 6 Cores - $999", "Intel Core i7 4930K - 3.4 GHz - 4 Cores - $583", "Intel Core i5 3570S - 3.1 GHz - 4 Cores - $205", "Intel Core i3 3220T - 2.8 GHz - 2 Cores - $117"})
    @DefaultValue(text="${PerformanceImportance == 3? 'Intel Core i7 4930K - 3.4 GHz - 4 Cores - $583': (PerformanceImportance == 2? 'Intel Core i5 3570S - 3.1 GHz - 4 Cores - $205': 'Intel Core i3 3220T - 2.8 GHz - 2 Cores - $117')}")
    public static final ValueProperty PROP_PROCESSOR = new ValueProperty(TYPE, "Processor");
    @Label(standard="memory")
    @PossibleValues(values={"4 GB RAM - $46", "8 GB RAM - $92", "16 GB RAM - $185", "32 GB RAM - $369"})
    @DefaultValue(text="${PerformanceImportance == 3? '16 GB RAM - $185': (PerformanceImportance == 2? '8 GB RAM - $92': '4 GB RAM - $46')}")
    public static final ValueProperty PROP_MEMORY = new ValueProperty(TYPE, "Memory");
    @Label(standard="storage")
    @PossibleValues(values={"Corsair 512GB SSD - $379", "Western Digital 4TB - $279", "Western Digital 3TB - $129", "Western Digital 1TB - $89"})
    @DefaultValue(text="${PerformanceImportance == 3 && StorageImportance < 3? 'Corsair 512GB SSD - $379': (StorageImportance == 3? 'Western Digital 4TB - $279': (StorageImportance == 2? 'Western Digital 3TB - $129': 'Western Digital 1TB - $89'))}")
    public static final ValueProperty PROP_STORAGE = new ValueProperty(TYPE, "Storage");
    @Label(standard="video card")
    @PossibleValues(values={"Sapphire Radeon HD 7990 6GB - $729", "VisionTek Radeon HD 7750 2GB - Eyefinity 6 - $232", "PowerColor Radeon HD 7750 2GB - $94"})
    @DefaultValue(text="${GamingImportance == 3? 'Sapphire Radeon HD 7990 6GB - $729': (GamingImportance == 2? 'PowerColor Radeon HD 7750 2GB - $94': null)}")
    public static final ValueProperty PROP_VIDEO_CARD = new ValueProperty(TYPE, "VideoCard");

    public Transient<PurchaseOrder> getPurchaseOrder();

    public void setPurchaseOrder(PurchaseOrder var1);

    public Value<Importance> getPerformanceImportance();

    public void setPerformanceImportance(String var1);

    public void setPerformanceImportance(Importance var1);

    public Value<Importance> getStorageImportance();

    public void setStorageImportance(String var1);

    public void setStorageImportance(Importance var1);

    public Value<Importance> getGamingImportance();

    public void setGamingImportance(String var1);

    public void setGamingImportance(Importance var1);

    public Value<String> getProcessor();

    public void setProcessor(String var1);

    public Value<String> getMemory();

    public void setMemory(String var1);

    public Value<String> getStorage();

    public void setStorage(String var1);

    public Value<String> getVideoCard();

    public void setVideoCard(String var1);

    @DelegateImplementation(value=PurchaseComputerOpMethods.class)
    public Status execute(ProgressMonitor var1);

    @Label(standard="importance")
    public static enum Importance {
        NOT_IMPORTANT,
        SOMEWHAT_IMPORTANT,
        VERY_IMPORTANT;

    }
}

