/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.util.List;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.util.EqualsFactory;
import org.eclipse.sapphire.util.HashCodeFactory;
import org.eclipse.sapphire.util.ListFactory;

public final class VersionConstraint {
    private static final int SM_RANGE_STARTING = 0;
    private static final int SM_RANGE_ENDED = 1;
    private static final int SM_VERSION_STARTING = 2;
    private static final int SM_VERSION_SEGMENT_STARTING = 3;
    private static final int SM_VERSION_SEGMENT_CONTINUING = 4;
    private static final int SM_VERSION_ENDED = 5;
    private final List<Range> ranges;

    public VersionConstraint(String expr) {
        if (expr == null) {
            throw new IllegalArgumentException();
        }
        ListFactory<Range> rangesListFactory = ListFactory.start();
        int state = 0;
        Range.Factory range = null;
        StringBuilder buf = null;
        int position = 0;
        int n = expr.length();
        while (position < n) {
            char ch = expr.charAt(position);
            switch (state) {
                case 0: {
                    if (ch == ' ') break;
                    if (ch == '[') {
                        range = new Range.Factory();
                        range.minVersionInclusive = true;
                        buf = new StringBuilder();
                        state = 2;
                        break;
                    }
                    if (ch == '(') {
                        range = new Range.Factory();
                        range.minVersionInclusive = false;
                        buf = new StringBuilder();
                        state = 2;
                        break;
                    }
                    if (ch >= '0' && ch <= '9') {
                        buf = new StringBuilder();
                        buf.append(ch);
                        state = 4;
                        break;
                    }
                    throw new IllegalArgumentException();
                }
                case 1: {
                    if (ch == ' ') break;
                    if (ch == ',') {
                        state = 0;
                        break;
                    }
                    throw new IllegalArgumentException();
                }
                case 2: {
                    if (ch == ' ') break;
                    if (ch >= '0' && ch <= '9') {
                        buf.append(ch);
                        state = 4;
                        break;
                    }
                    throw new IllegalArgumentException();
                }
                case 3: {
                    if (ch >= '0' && ch <= '9') {
                        buf.append(ch);
                        state = 4;
                        break;
                    }
                    throw new IllegalArgumentException();
                }
                case 4: {
                    if (ch >= '0' && ch <= '9') {
                        buf.append(ch);
                        break;
                    }
                    if (ch == '.') {
                        buf.append(ch);
                        state = 3;
                        break;
                    }
                    if (ch == ' ') {
                        state = 5;
                        break;
                    }
                    if (ch == ']') {
                        if (range == null) {
                            range = new Range.Factory();
                        }
                        range.maxVersion = new Version(buf.toString());
                        range.maxVersionInclusive = true;
                        rangesListFactory.add(range.create());
                        range = null;
                        buf = null;
                        state = 1;
                        break;
                    }
                    if (ch == ')') {
                        if (range == null) {
                            range = new Range.Factory();
                        }
                        range.maxVersion = new Version(buf.toString());
                        range.maxVersionInclusive = false;
                        rangesListFactory.add(range.create());
                        range = null;
                        buf = null;
                        state = 1;
                        break;
                    }
                    if (ch == '-') {
                        if (range == null) {
                            throw new IllegalArgumentException();
                        }
                        range.minVersion = new Version(buf.toString());
                        buf = new StringBuilder();
                        state = 2;
                        break;
                    }
                    if (ch == ',') {
                        if (range == null) {
                            range = new Range.Factory();
                            range.maxVersion = range.minVersion = new Version(buf.toString());
                            range.minVersionInclusive = true;
                            range.maxVersionInclusive = true;
                        } else {
                            range.minVersion = new Version(buf.toString());
                        }
                        rangesListFactory.add(range.create());
                        range = null;
                        buf = null;
                        state = 0;
                        break;
                    }
                    throw new IllegalArgumentException();
                }
                case 5: {
                    if (ch == ' ') break;
                    if (ch == ']') {
                        if (range == null) {
                            range = new Range.Factory();
                        }
                        range.maxVersion = new Version(buf.toString());
                        range.maxVersionInclusive = true;
                        rangesListFactory.add(range.create());
                        range = null;
                        buf = null;
                        state = 1;
                        break;
                    }
                    if (ch == ')') {
                        if (range == null) {
                            range = new Range.Factory();
                        }
                        range.maxVersion = new Version(buf.toString());
                        range.maxVersionInclusive = false;
                        rangesListFactory.add(range.create());
                        range = null;
                        buf = null;
                        state = 1;
                        break;
                    }
                    if (ch == '-') {
                        if (range == null) {
                            throw new IllegalArgumentException();
                        }
                        range.minVersion = new Version(buf.toString());
                        buf = new StringBuilder();
                        state = 2;
                        break;
                    }
                    if (ch == ',') {
                        if (range == null) {
                            range = new Range.Factory();
                            range.maxVersion = range.minVersion = new Version(buf.toString());
                            range.minVersionInclusive = true;
                            range.maxVersionInclusive = true;
                        } else {
                            range.minVersion = new Version(buf.toString());
                        }
                        rangesListFactory.add(range.create());
                        range = null;
                        buf = null;
                        state = 0;
                        break;
                    }
                    throw new IllegalArgumentException();
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++position;
        }
        if (state == 4 || state == 5) {
            if (range == null) {
                range = new Range.Factory();
                range.maxVersion = range.minVersion = new Version(buf.toString());
                range.minVersionInclusive = true;
                range.maxVersionInclusive = true;
            } else {
                range.minVersion = new Version(buf.toString());
            }
            rangesListFactory.add(range.create());
            range = null;
            buf = null;
            state = 1;
        }
        if (state != 1) {
            throw new IllegalArgumentException();
        }
        this.ranges = rangesListFactory.result();
    }

    public List<Range> ranges() {
        return this.ranges;
    }

    public boolean check(Version version) {
        for (Range subexpr : this.ranges) {
            if (!subexpr.check(version)) continue;
            return true;
        }
        return false;
    }

    public boolean check(String version) {
        return this.check(new Version(version));
    }

    public boolean equals(Object obj) {
        if (obj instanceof VersionConstraint) {
            VersionConstraint constraint = (VersionConstraint)obj;
            return this.ranges.equals(constraint.ranges);
        }
        return false;
    }

    public int hashCode() {
        return this.ranges.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (Range subexpr : this.ranges) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(subexpr.toString());
        }
        return buf.toString();
    }

    public static final class Range {
        private final Limit min;
        private final Limit max;

        private Range(Limit min, Limit max) {
            if (min == null && max == null) {
                throw new IllegalArgumentException();
            }
            this.min = min;
            this.max = max;
        }

        public Limit min() {
            return this.min;
        }

        public Limit max() {
            return this.max;
        }

        public boolean check(Version version) {
            int res;
            if (!(this.min == null || (res = version.compareTo(this.min.version())) > 0 || res == 0 && this.min.inclusive())) {
                return false;
            }
            return this.max == null || (res = version.compareTo(this.max.version())) < 0 || res == 0 && this.max.inclusive();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Range) {
                Range range = (Range)obj;
                return EqualsFactory.start().add(this.min, range.min).add(this.max, range.max).result();
            }
            return false;
        }

        public int hashCode() {
            return HashCodeFactory.start().add(this.min).add(this.max).result();
        }

        public String toString() {
            if (this.min != null && this.max != null && this.min.version().equals(this.max.version()) && this.min.inclusive() == this.max.inclusive()) {
                return this.min.version().toString();
            }
            StringBuffer buf = new StringBuffer();
            if (this.min != null) {
                buf.append(this.min.inclusive() ? (char)'[' : '(');
                buf.append(this.min.version().toString());
            }
            if (this.max != null) {
                if (buf.length() != 0) {
                    buf.append('-');
                }
                buf.append(this.max.version().toString());
                buf.append(this.max.inclusive() ? (char)']' : ')');
            }
            return buf.toString();
        }

        private static final class Factory {
            public Version minVersion;
            public boolean minVersionInclusive;
            public Version maxVersion;
            public boolean maxVersionInclusive;

            private Factory() {
            }

            public Range create() {
                Limit min = this.minVersion == null ? null : new Limit(this.minVersion, this.minVersionInclusive);
                Limit max = this.maxVersion == null ? null : new Limit(this.maxVersion, this.maxVersionInclusive);
                return new Range(min, max);
            }
        }

        public static final class Limit {
            private final Version version;
            private final boolean inclusive;

            private Limit(Version version, boolean inclusive) {
                if (version == null) {
                    throw new IllegalArgumentException();
                }
                this.version = version;
                this.inclusive = inclusive;
            }

            public Version version() {
                return this.version;
            }

            public boolean inclusive() {
                return this.inclusive;
            }

            public boolean equals(Object obj) {
                if (obj instanceof Limit) {
                    Limit limit = (Limit)obj;
                    return this.version.equals(limit.version) && this.inclusive == limit.inclusive;
                }
                return false;
            }

            public int hashCode() {
                return this.version.hashCode() ^ Boolean.valueOf(this.inclusive).hashCode();
            }
        }
    }
}

