/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.MasterConversionService;
import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.EnumValueType;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class EnumPossibleValuesService
extends PossibleValuesService {
    private final List<String> values = new ArrayList<String>();

    @Override
    protected void initPossibleValuesService() {
        ValueProperty property = this.context(ValueProperty.class);
        EnumValueType enumType = new EnumValueType(property.getTypeClass());
        MasterConversionService masterConversionService = property.service(MasterConversionService.class);
        Enum<?>[] enumArray = enumType.getItems();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum<?> item = enumArray[n2];
            this.values.add(masterConversionService.convert(item, String.class));
            ++n2;
        }
    }

    @Override
    protected void compute(Set<String> values) {
        values.addAll(this.values);
    }

    @Override
    public Status problem(Value<?> value) {
        return Status.createOkStatus();
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && Enum.class.isAssignableFrom(property.getTypeClass());
        }
    }
}

