/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.address;

import java.util.Set;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.samples.address.Address;
import org.eclipse.sapphire.samples.zipcodes.ZipCodeRepository;

public final class CityPossibleValuesService
extends PossibleValuesService {
    @Text(value="\"${City}\" is not a valid city for the specified state and ZIP code.")
    private static LocalizableText message;

    static {
        LocalizableText.init(CityPossibleValuesService.class);
    }

    protected void initPossibleValuesService() {
        this.invalidValueMessage = message.text();
        final Address address = (Address)this.context(Address.class);
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                String city;
                CityPossibleValuesService.this.refresh();
                Set values = CityPossibleValuesService.this.values();
                if (values.size() == 1 && !(city = (String)values.iterator().next()).equalsIgnoreCase(address.getCity().text())) {
                    address.setCity(city);
                }
            }
        };
        address.getState().attach((Listener)listener);
        address.getZipCode().attach((Listener)listener);
    }

    protected void compute(Set<String> values) {
        Address address = (Address)this.context(Address.class);
        String state = address.getState().text();
        String zip = address.getZipCode().text();
        values.addAll(ZipCodeRepository.getCities(zip, state));
    }
}

