/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.sqlschema;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.samples.sqlschema.Column;
import org.eclipse.sapphire.samples.sqlschema.ColumnType;
import org.eclipse.sapphire.samples.sqlschema.ForeignKey;
import org.eclipse.sapphire.services.ReferenceService;
import org.eclipse.sapphire.services.ValidationService;

public final class FKColumnAssociationValidator
extends ValidationService {
    @Text(value="Foreign key column types do not match")
    private static LocalizableText error;
    private ForeignKey.ColumnAssociation association;
    private ReferenceService<?> localColumnReferenceService;
    private Column localColumn;
    private ReferenceService<?> referencedColumnReferenceService;
    private Column referencedColumn;
    private Listener referenceServiceListener;
    private Listener columnTypeListener;

    static {
        LocalizableText.init(FKColumnAssociationValidator.class);
    }

    protected void initValidationService() {
        this.referenceServiceListener = new Listener(){

            public void handle(Event event) {
                FKColumnAssociationValidator.this.refresh();
            }
        };
        this.columnTypeListener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                FKColumnAssociationValidator.this.refresh();
            }
        };
        this.association = (ForeignKey.ColumnAssociation)this.context(ForeignKey.ColumnAssociation.class);
        this.localColumnReferenceService = (ReferenceService)this.association.getLocalColumn().service(ReferenceService.class);
        this.localColumnReferenceService.attach(this.referenceServiceListener);
        this.referencedColumnReferenceService = (ReferenceService)this.association.getReferencedColumn().service(ReferenceService.class);
        this.referencedColumnReferenceService.attach(this.referenceServiceListener);
    }

    protected Status compute() {
        this.localColumn = this.column(this.association.getLocalColumn(), this.localColumn);
        this.referencedColumn = this.column(this.association.getReferencedColumn(), this.referencedColumn);
        if (this.localColumn != null && this.referencedColumn != null) {
            ColumnType localColumnType = (ColumnType)((Object)this.localColumn.getType().content());
            ColumnType referencedColumnType = (ColumnType)((Object)this.referencedColumn.getType().content());
            if (localColumnType != null && referencedColumnType != null && localColumnType != referencedColumnType) {
                return Status.createErrorStatus((String)error.text());
            }
        }
        return Status.createOkStatus();
    }

    private Column column(ReferenceValue<String, Column> property, Column cached) {
        Column current = (Column)property.target();
        if (cached != current) {
            if (cached != null && !cached.disposed()) {
                cached.getType().detach(this.columnTypeListener);
            }
            if (current != null) {
                current.getType().attach(this.columnTypeListener);
            }
        }
        return current;
    }

    public void dispose() {
        this.association = null;
        this.localColumnReferenceService.detach(this.referenceServiceListener);
        this.localColumnReferenceService = null;
        this.referencedColumnReferenceService.detach(this.referenceServiceListener);
        this.referencedColumnReferenceService = null;
        this.referenceServiceListener = null;
        if (this.localColumn != null && !this.localColumn.disposed()) {
            this.localColumn.getType().detach(this.columnTypeListener);
            this.localColumn = null;
        }
        if (this.referencedColumn != null && !this.referencedColumn.disposed()) {
            this.referencedColumn.getType().detach(this.columnTypeListener);
            this.referencedColumn = null;
        }
        this.columnTypeListener = null;
    }
}

