/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.sdk.extensibility.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Filter;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.sdk.extensibility.ExtensionSummaryExportOp;
import org.eclipse.sapphire.sdk.extensibility.ExtensionSummarySectionColumnDef;
import org.eclipse.sapphire.sdk.extensibility.ExtensionSummarySectionDef;
import org.eclipse.sapphire.sdk.extensibility.FunctionDef;
import org.eclipse.sapphire.sdk.extensibility.SapphireExtensionDef;
import org.eclipse.sapphire.sdk.extensibility.ServiceDef;
import org.eclipse.sapphire.ui.def.ActionContextRef;
import org.eclipse.sapphire.ui.def.ActionDef;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.def.ActionHandlerFactoryDef;
import org.eclipse.sapphire.ui.def.PresentationStyleDef;
import org.eclipse.sapphire.util.StringUtil;
import org.osgi.framework.Bundle;

public final class ExtensionSummaryExportOpMethods {
    private static String STYLE;

    public static String execute(ExtensionSummaryExportOp op, List<SapphireExtensionDef> extensions, Filter<Element> filter) {
        ElementList<ExtensionSummarySectionDef> sections;
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        if (((Boolean)op.getCreateFinishedDocument().content()).booleanValue()) {
            out.println("<html>");
            out.println();
            out.println("<head>");
            out.println("  <title>" + (String)op.getDocumentTitle().content() + "</title>");
            if (((Boolean)op.getEmbedDefaultStyle().content()).booleanValue()) {
                out.println(ExtensionSummaryExportOpMethods.style());
            }
            out.println("</head>");
            out.println();
            out.println("<body>");
            String documentBodyTitle = (String)op.getDocumentBodyTitle().content();
            if (documentBodyTitle != null) {
                out.println("<h1>" + documentBodyTitle + "</h1>");
            }
        }
        if ((sections = op.getSections()).isEmpty()) {
            ExtensionSummarySectionDef def = (ExtensionSummarySectionDef)sections.insert();
            def.setExtensionType(SapphireExtensionDef.PROP_SERVICES.name());
            def = (ExtensionSummarySectionDef)sections.insert();
            def.setExtensionType(SapphireExtensionDef.PROP_FUNCTIONS.name());
            def = (ExtensionSummarySectionDef)sections.insert();
            def.setExtensionType(SapphireExtensionDef.PROP_ACTIONS.name());
            def = (ExtensionSummarySectionDef)sections.insert();
            def.setExtensionType(SapphireExtensionDef.PROP_ACTION_HANDLERS.name());
            def = (ExtensionSummarySectionDef)sections.insert();
            def.setExtensionType(SapphireExtensionDef.PROP_ACTION_HANDLER_FACTORIES.name());
            def = (ExtensionSummarySectionDef)sections.insert();
            def.setExtensionType(SapphireExtensionDef.PROP_PRESENTATION_STYLES.name());
        }
        for (ExtensionSummarySectionDef def : sections) {
            SectionWriter sectionWriter;
            String extensionType = def.getExtensionType().text();
            if (extensionType.equals(SapphireExtensionDef.PROP_SERVICES.name())) {
                sectionWriter = new ServicesSectionWriter(out, extensions, filter, def);
            } else if (extensionType.endsWith(SapphireExtensionDef.PROP_FUNCTIONS.name())) {
                sectionWriter = new FunctionsSectionWriter(out, extensions, filter, def);
            } else if (extensionType.endsWith(SapphireExtensionDef.PROP_ACTIONS.name())) {
                sectionWriter = new ActionsSectionWriter(out, extensions, filter, def);
            } else if (extensionType.endsWith(SapphireExtensionDef.PROP_ACTION_HANDLERS.name())) {
                sectionWriter = new ActionHandlersSectionWriter(out, extensions, filter, def);
            } else if (extensionType.endsWith(SapphireExtensionDef.PROP_ACTION_HANDLER_FACTORIES.name())) {
                sectionWriter = new ActionHandlerFactoriesSectionWriter(out, extensions, filter, def);
            } else if (extensionType.endsWith(SapphireExtensionDef.PROP_PRESENTATION_STYLES.name())) {
                sectionWriter = new PresentationStylesSectionWriter(out, extensions, filter, def);
            } else {
                throw new IllegalStateException();
            }
            sectionWriter.write();
        }
        if (((Boolean)op.getCreateFinishedDocument().content()).booleanValue()) {
            out.println("<br/><br/>");
            out.println();
            out.println("</body>");
            out.println();
            out.println("</html>");
        }
        out.flush();
        return stringWriter.getBuffer().toString();
    }

    private static String style() {
        if (STYLE == null) {
            StringBuilder buf;
            block16: {
                buf = new StringBuilder();
                buf.append("<style type=\"text/css\">\n");
                try {
                    URL url;
                    Bundle bundle = Platform.getBundle((String)"org.eclipse.sapphire.doc");
                    if (bundle == null || (url = bundle.getEntry("html/style.css")) == null) break block16;
                    InputStream in = url.openStream();
                    try {
                        InputStreamReader reader = new InputStreamReader(in, StringUtil.UTF8);
                        try {
                            char[] chars = new char[1024];
                            int count = reader.read(chars);
                            while (count != -1) {
                                buf.append(chars, 0, count);
                                count = reader.read(chars);
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {
                            ((Reader)reader).close();
                        }
                        catch (IOException iOException) {}
                    }
                    catch (Throwable throwable) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                catch (Exception e) {
                    ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                }
            }
            buf.append("\n</style>");
            STYLE = buf.toString();
        }
        return STYLE;
    }

    private static String normalize(String text) {
        return ExtensionSummaryExportOpMethods.normalize(text, "");
    }

    private static String normalize(String text, String textForNull) {
        return text == null || text.trim().length() == 0 ? textForNull : text;
    }

    private static int comp(String x, String y) {
        if (x == null) {
            return -1;
        }
        if (y == null) {
            return 1;
        }
        return x.compareToIgnoreCase(y);
    }

    private static String formatClassName(String className) {
        int lastDotPlusOne;
        StringBuilder buf = new StringBuilder();
        int lastDot = className.lastIndexOf(46);
        if (lastDot != -1) {
            buf.append("<font color=\"#888888\">");
            buf.append(className.substring(0, lastDot + 1));
            buf.append("</font>");
        }
        if ((lastDotPlusOne = lastDot + 1) < className.length()) {
            buf.append(className.substring(lastDotPlusOne));
        }
        return buf.toString();
    }

    private static final class ActionHandlerFactoriesSectionWriter
    extends SectionWriter {
        public ActionHandlerFactoriesSectionWriter(PrintWriter out, List<SapphireExtensionDef> extensions, Filter<Element> filter, ExtensionSummarySectionDef def) {
            super(out, extensions, filter, def);
        }

        @Override
        protected void sort(List<Element> extElements) {
            Collections.sort(extElements, new Comparator<Element>(){

                @Override
                public int compare(Element a, Element b) {
                    ActionHandlerFactoryDef x = (ActionHandlerFactoryDef)a;
                    ActionHandlerFactoryDef y = (ActionHandlerFactoryDef)b;
                    int res = ExtensionSummaryExportOpMethods.comp((String)x.getAction().content(), (String)y.getAction().content());
                    if (res == 0) {
                        res = ExtensionSummaryExportOpMethods.comp(x.getImplClass().text(), y.getImplClass().text());
                    }
                    return res;
                }
            });
        }

        @Override
        protected List<PropertyDef> getDefaultColumns() {
            ArrayList<PropertyDef> columns = new ArrayList<PropertyDef>();
            columns.add((PropertyDef)ActionHandlerFactoryDef.PROP_ACTION);
            columns.add((PropertyDef)ActionHandlerFactoryDef.PROP_DESCRIPTION);
            return columns;
        }
    }

    private static final class ActionHandlersSectionWriter
    extends SectionWriter {
        public ActionHandlersSectionWriter(PrintWriter out, List<SapphireExtensionDef> extensions, Filter<Element> filter, ExtensionSummarySectionDef def) {
            super(out, extensions, filter, def);
        }

        @Override
        protected void sort(List<Element> extElements) {
            Collections.sort(extElements, new Comparator<Element>(){

                @Override
                public int compare(Element a, Element b) {
                    ActionHandlerDef x = (ActionHandlerDef)a;
                    ActionHandlerDef y = (ActionHandlerDef)b;
                    int res = ExtensionSummaryExportOpMethods.comp((String)x.getAction().content(), (String)y.getAction().content());
                    if (res == 0) {
                        res = ExtensionSummaryExportOpMethods.comp((String)x.getId().content(), (String)y.getId().content());
                    }
                    return res;
                }
            });
        }

        @Override
        protected List<PropertyDef> getDefaultColumns() {
            ArrayList<PropertyDef> columns = new ArrayList<PropertyDef>();
            columns.add((PropertyDef)ActionHandlerDef.PROP_ACTION);
            columns.add((PropertyDef)ActionHandlerDef.PROP_ID);
            columns.add((PropertyDef)ActionHandlerDef.PROP_DESCRIPTION);
            return columns;
        }
    }

    private static final class ActionsSectionWriter
    extends SectionWriter {
        public ActionsSectionWriter(PrintWriter out, List<SapphireExtensionDef> extensions, Filter<Element> filter, ExtensionSummarySectionDef def) {
            super(out, extensions, filter, def);
        }

        @Override
        protected void sort(List<Element> extElements) {
            Collections.sort(extElements, new Comparator<Element>(){

                @Override
                public int compare(Element a, Element b) {
                    ActionDef x = (ActionDef)a;
                    ActionDef y = (ActionDef)b;
                    return ExtensionSummaryExportOpMethods.comp((String)x.getId().content(), (String)y.getId().content());
                }
            });
        }

        @Override
        protected List<PropertyDef> getDefaultColumns() {
            ArrayList<PropertyDef> columns = new ArrayList<PropertyDef>();
            columns.add((PropertyDef)ActionDef.PROP_ID);
            columns.add((PropertyDef)ActionDef.PROP_DESCRIPTION);
            columns.add((PropertyDef)ActionDef.PROP_KEY_BINDING);
            columns.add((PropertyDef)ActionDef.PROP_CONTEXTS);
            return columns;
        }

        @Override
        protected String getCellText(Element element, PropertyDef property) {
            if (property == ActionDef.PROP_CONTEXTS) {
                StringBuilder contexts = new StringBuilder();
                for (ActionContextRef context : ((ActionDef)element).getContexts()) {
                    if (contexts.length() > 0) {
                        contexts.append("<br/>");
                    }
                    contexts.append(ExtensionSummaryExportOpMethods.normalize(context.getContext().text()));
                }
                return contexts.toString();
            }
            return super.getCellText(element, property);
        }
    }

    private static final class FunctionsSectionWriter
    extends SectionWriter {
        public FunctionsSectionWriter(PrintWriter out, List<SapphireExtensionDef> extensions, Filter<Element> filter, ExtensionSummarySectionDef def) {
            super(out, extensions, filter, def);
        }

        @Override
        protected void sort(List<Element> extElements) {
            Collections.sort(extElements, new Comparator<Element>(){

                @Override
                public int compare(Element a, Element b) {
                    FunctionDef x = (FunctionDef)a;
                    FunctionDef y = (FunctionDef)b;
                    return ExtensionSummaryExportOpMethods.comp((String)x.getName().content(), (String)y.getName().content());
                }
            });
        }

        @Override
        protected List<PropertyDef> getDefaultColumns() {
            ArrayList<PropertyDef> columns = new ArrayList<PropertyDef>();
            columns.add((PropertyDef)FunctionDef.PROP_NAME);
            columns.add((PropertyDef)FunctionDef.PROP_DESCRIPTION);
            columns.add((PropertyDef)FunctionDef.PROP_IMPL_CLASS);
            return columns;
        }
    }

    private static final class PresentationStylesSectionWriter
    extends SectionWriter {
        public PresentationStylesSectionWriter(PrintWriter out, List<SapphireExtensionDef> extensions, Filter<Element> filter, ExtensionSummarySectionDef def) {
            super(out, extensions, filter, def);
        }

        @Override
        protected void sort(List<Element> extElements) {
            Collections.sort(extElements, new Comparator<Element>(){

                @Override
                public int compare(Element a, Element b) {
                    PresentationStyleDef x = (PresentationStyleDef)a;
                    PresentationStyleDef y = (PresentationStyleDef)b;
                    return ExtensionSummaryExportOpMethods.comp((String)x.getId().content(), (String)y.getId().content());
                }
            });
        }

        @Override
        protected List<PropertyDef> getDefaultColumns() {
            ArrayList<PropertyDef> columns = new ArrayList<PropertyDef>();
            columns.add((PropertyDef)PresentationStyleDef.PROP_ID);
            columns.add((PropertyDef)PresentationStyleDef.PROP_PART_TYPE);
            columns.add((PropertyDef)PresentationStyleDef.PROP_DESCRIPTION);
            return columns;
        }
    }

    private static abstract class SectionWriter {
        private final PrintWriter out;
        private final List<SapphireExtensionDef> extensions;
        private final Filter<Element> filter;
        private final ExtensionSummarySectionDef def;

        public SectionWriter(PrintWriter out, List<SapphireExtensionDef> extensions, Filter<Element> filter, ExtensionSummarySectionDef def) {
            this.out = out;
            this.extensions = extensions;
            this.filter = filter;
            this.def = def;
        }

        public final void write() {
            ListProperty extTypeListProperty = (ListProperty)SapphireExtensionDef.TYPE.property(this.def.getExtensionType().text());
            ElementType extType = extTypeListProperty.getType();
            ArrayList<Element> extElements = new ArrayList<Element>();
            if (this.filter == null) {
                for (SapphireExtensionDef extension : this.extensions) {
                    extElements.addAll((Collection<Element>)extension.property(extTypeListProperty));
                }
            } else {
                for (SapphireExtensionDef extension : this.extensions) {
                    for (Object extElement : extension.property(extTypeListProperty)) {
                        if (!this.filter.allows(extElement)) continue;
                        extElements.add((Element)extElement);
                    }
                }
            }
            if (!extElements.isEmpty()) {
                this.sort(extElements);
                if (((Boolean)this.def.getIncludeSectionHeader().content()).booleanValue()) {
                    ExtensionSummaryExportOp op = (ExtensionSummaryExportOp)this.def.nearest(ExtensionSummaryExportOp.class);
                    String sectionHeaderLevel = (Boolean)op.getCreateFinishedDocument().content() == false || op.getDocumentBodyTitle().content() == null ? "h1" : "h2";
                    this.out.println();
                    this.out.print("<a name=\"");
                    this.out.print(extTypeListProperty.name());
                    this.out.print("\"><");
                    this.out.print(sectionHeaderLevel);
                    this.out.print('>');
                    this.out.print(extTypeListProperty.getLabel(true, CapitalizationType.TITLE_STYLE, false));
                    this.out.print("</");
                    this.out.print(sectionHeaderLevel);
                    this.out.print("></a>");
                    this.out.println();
                }
                ArrayList<PropertyDef> columns = new ArrayList<PropertyDef>();
                for (ExtensionSummarySectionColumnDef cdef : this.def.getColumns()) {
                    PropertyDef cprop = extType.property(cdef.getName().text());
                    if (cprop == null) continue;
                    columns.add(cprop);
                }
                if (columns.isEmpty()) {
                    columns.addAll(this.getDefaultColumns());
                }
                Iterator itr = columns.iterator();
                while (itr.hasNext()) {
                    PropertyDef cprop = (PropertyDef)itr.next();
                    boolean empty = true;
                    if (cprop instanceof ValueProperty) {
                        ValueProperty cvprop = (ValueProperty)cprop;
                        for (Element element : extElements) {
                            if (element.property(cvprop).text() == null) continue;
                            empty = false;
                            break;
                        }
                    } else if (cprop instanceof ListProperty) {
                        ListProperty clprop = (ListProperty)cprop;
                        for (Element element : extElements) {
                            if (element.property(clprop).empty()) continue;
                            empty = false;
                            break;
                        }
                    } else {
                        empty = false;
                    }
                    if (!empty) continue;
                    itr.remove();
                }
                this.out.println();
                this.out.println("<table>");
                this.out.println("  <tr>");
                for (PropertyDef column : columns) {
                    this.out.print("    <th>");
                    this.out.print(column.getLabel(true, CapitalizationType.TITLE_STYLE, true));
                    this.out.print("</th>");
                    this.out.println();
                }
                this.out.println("  </tr>");
                for (Element extElement : extElements) {
                    this.out.println("  <tr>");
                    for (PropertyDef column : columns) {
                        String text = this.getCellText(extElement, column);
                        this.out.print("    <td>");
                        this.out.print(ExtensionSummaryExportOpMethods.normalize(text, "&nbsp;"));
                        this.out.print("</td>");
                        this.out.println();
                    }
                    this.out.println("  </tr>");
                }
                this.out.println("</table>");
            }
        }

        protected void sort(List<Element> extElements) {
        }

        protected abstract List<PropertyDef> getDefaultColumns();

        protected String getCellText(Element element, PropertyDef property) {
            String text = null;
            if (property instanceof ValueProperty) {
                text = element.property((ValueProperty)property).text();
                Reference ref = (Reference)property.getAnnotation(Reference.class);
                if (ref != null && ref.target() == Class.class) {
                    text = ExtensionSummaryExportOpMethods.formatClassName(text);
                }
            } else if (property instanceof ListProperty) {
                ListProperty listProperty = (ListProperty)property;
                ValueProperty entryValueProperty = (ValueProperty)listProperty.getType().properties().first();
                StringBuilder buf = new StringBuilder();
                for (Element entry : element.property(listProperty)) {
                    String entryValuePropertyText = entry.property(entryValueProperty).text();
                    if (entryValuePropertyText == null) continue;
                    if (buf.length() > 0) {
                        buf.append("<br/>");
                    }
                    buf.append(entryValuePropertyText);
                }
                text = buf.toString();
            }
            if (text == null) {
                text = "";
            }
            return text;
        }
    }

    private static final class ServicesSectionWriter
    extends SectionWriter {
        public ServicesSectionWriter(PrintWriter out, List<SapphireExtensionDef> extensions, Filter<Element> filter, ExtensionSummarySectionDef def) {
            super(out, extensions, filter, def);
        }

        @Override
        protected void sort(List<Element> extElements) {
            Collections.sort(extElements, new Comparator<Element>(){

                @Override
                public int compare(Element a, Element b) {
                    ServiceDef x = (ServiceDef)a;
                    ServiceDef y = (ServiceDef)b;
                    return ExtensionSummaryExportOpMethods.comp((String)x.getId().content(), (String)y.getId().content());
                }
            });
        }

        @Override
        protected List<PropertyDef> getDefaultColumns() {
            ArrayList<PropertyDef> columns = new ArrayList<PropertyDef>();
            columns.add((PropertyDef)ServiceDef.PROP_ID);
            columns.add((PropertyDef)ServiceDef.PROP_DESCRIPTION);
            columns.add((PropertyDef)ServiceDef.PROP_CONTEXTS);
            return columns;
        }
    }
}

