/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el.functions.content;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.tests.modeling.el.TestExpr;
import org.eclipse.sapphire.tests.modeling.el.functions.content.TestElement;
import org.junit.Test;

public final class ContentFunctionTests
extends TestExpr {
    @Test
    public void testContentFunction() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        FunctionResult fr = ExpressionLanguageParser.parse((String)"${ IntegerValue.Content }").evaluate((FunctionContext)context);
        try {
            ContentFunctionTests.assertNull((Object)fr.value());
            element.setIntegerValue(3);
            ContentFunctionTests.assertEquals((Object)3, (Object)fr.value());
            element.setIntegerValue("abc");
            ContentFunctionTests.assertNull((Object)fr.value());
        }
        finally {
            fr.dispose();
        }
        fr = ExpressionLanguageParser.parse((String)"${ IntegerValueWithDefault.Content }").evaluate((FunctionContext)context);
        try {
            ContentFunctionTests.assertEquals((Object)1, (Object)fr.value());
            element.setIntegerValueWithDefault(3);
            ContentFunctionTests.assertEquals((Object)3, (Object)fr.value());
            element.setIntegerValueWithDefault("abc");
            ContentFunctionTests.assertEquals((Object)1, (Object)fr.value());
        }
        finally {
            fr.dispose();
        }
        fr = ExpressionLanguageParser.parse((String)"${ Transient.Content }").evaluate((FunctionContext)context);
        try {
            ContentFunctionTests.assertNull((Object)fr.value());
            element.setTransient((Object)this);
            ContentFunctionTests.assertSame((Object)((Object)this), (Object)fr.value());
        }
        finally {
            fr.dispose();
        }
    }

    @Test
    public void testContentFunctionNull() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        FunctionResult fr = ExpressionLanguageParser.parse((String)"${ Content( null ) }").evaluate((FunctionContext)context);
        try {
            Status st = fr.status();
            ContentFunctionTests.assertEquals((Object)Status.Severity.ERROR, (Object)st.severity());
            ContentFunctionTests.assertEquals((Object)"Function Content does not accept nulls in position 0.", (Object)st.message());
        }
        finally {
            fr.dispose();
        }
    }

    @Test
    public void testContentFunctionWrongType() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        FunctionResult fr = ExpressionLanguageParser.parse((String)"${ Content( 'abc' ) }").evaluate((FunctionContext)context);
        try {
            Status st = fr.status();
            ContentFunctionTests.assertEquals((Object)Status.Severity.ERROR, (Object)st.severity());
            ContentFunctionTests.assertEquals((Object)"Function Content( java.lang.String ) is undefined.", (Object)st.message());
        }
        finally {
            fr.dispose();
        }
    }
}

