/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el.functions.size;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.tests.modeling.el.TestExpr;
import org.eclipse.sapphire.tests.modeling.el.functions.size.TestElement;
import org.junit.Test;

public final class SizeFunctionTests
extends TestExpr {
    @Test
    public void testSizeFunctionOnList() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        FunctionResult fr = ExpressionLanguageParser.parse((String)"${ List.Size }").evaluate((FunctionContext)context);
        try {
            SizeFunctionTests.assertEquals((Object)0, (Object)fr.value());
            element.getList().insert();
            SizeFunctionTests.assertEquals((Object)1, (Object)fr.value());
            element.getList().insert();
            SizeFunctionTests.assertEquals((Object)2, (Object)fr.value());
            element.getList().clear();
            SizeFunctionTests.assertEquals((Object)0, (Object)fr.value());
        }
        finally {
            fr.dispose();
        }
    }

    @Test
    public void testSizeFunctionOnValue() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        FunctionResult fr = ExpressionLanguageParser.parse((String)"${ Value.Size }").evaluate((FunctionContext)context);
        try {
            SizeFunctionTests.assertEquals((Object)0, (Object)fr.value());
            element.setValue("abc");
            SizeFunctionTests.assertEquals((Object)3, (Object)fr.value());
            element.setValue(null);
            SizeFunctionTests.assertEquals((Object)0, (Object)fr.value());
        }
        finally {
            fr.dispose();
        }
    }

    @Test
    public void testSizeFunctionOnString() {
        FunctionContext context = new FunctionContext();
        FunctionResult fr = ExpressionLanguageParser.parse((String)"${ Size( 'abcdef' ) }").evaluate(context);
        try {
            SizeFunctionTests.assertEquals((Object)6, (Object)fr.value());
        }
        finally {
            fr.dispose();
        }
    }

    @Test
    public void testSizeFunctionNull() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        FunctionResult fr = ExpressionLanguageParser.parse((String)"${ Size( null ) }").evaluate((FunctionContext)context);
        try {
            Status st = fr.status();
            SizeFunctionTests.assertEquals((Object)Status.Severity.ERROR, (Object)st.severity());
            SizeFunctionTests.assertEquals((Object)"Function Size does not accept nulls in position 0.", (Object)st.message());
        }
        finally {
            fr.dispose();
        }
    }

    @Test
    public void testSizeFunctionWrongType() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        FunctionResult fr = ExpressionLanguageParser.parse((String)"${ Size( 3 ) }").evaluate((FunctionContext)context);
        try {
            Status st = fr.status();
            SizeFunctionTests.assertEquals((Object)Status.Severity.ERROR, (Object)st.severity());
            SizeFunctionTests.assertEquals((Object)"Function Size cannot be applied to a java.math.BigInteger object.", (Object)st.message());
        }
        finally {
            fr.dispose();
        }
    }
}

